/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.handler;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;
import org.xwiki.stability.Unstable;

public class ReferenceTagHandler
extends TagHandler {
    public ReferenceTagHandler() {
        super(true);
    }

    @Override
    protected void begin(TagContext context) {
        this.setAccumulateContent(true);
    }

    @Override
    protected void end(TagContext context) {
        WikiParameters parameters = context.getParams();
        WikiParameter ref = parameters.getParameter("href");
        if (ref != null) {
            if (this.isFreeStandingReference(context)) {
                context.getScannerContext().onReference(ref.getValue());
            } else {
                String content = context.getContent();
                WikiReference reference = new WikiReference(ref.getValue(), content, this.removeMeaningfulParameters(parameters));
                context.getScannerContext().onReference(reference);
            }
        }
    }

    protected boolean isFreeStandingReference(TagContext context) {
        WikiParameters parameters = context.getParams();
        boolean isFreeStanding = this.containsFreeStandingClass(parameters);
        if (isFreeStanding) {
            return this.removeMeaningfulParameters(parameters).getSize() == 0;
        }
        return false;
    }

    @Unstable
    protected boolean containsFreeStandingClass(WikiParameters parameters) {
        return this.containsClass(parameters, "wikimodel-freestanding");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Unstable
    protected boolean containsClass(WikiParameters parameters, String className) {
        WikiParameter classParam = parameters.getParameter("class");
        if (classParam == null) return false;
        if (classParam.getValue() == null) return false;
        if (!Arrays.stream(classParam.getValue().split(" ")).anyMatch(className::equalsIgnoreCase)) return false;
        return true;
    }

    @Unstable
    protected WikiParameters removeClass(WikiParameters parameters, String className) {
        WikiParameter classParam = parameters.getParameter("class");
        WikiParameters result = parameters;
        if (classParam != null) {
            String classes = classParam.getValue();
            if (StringUtils.isNotBlank((CharSequence)classes)) {
                classes = Arrays.stream(classes.split(" ")).filter(Predicate.not(value -> StringUtils.equalsIgnoreCase((CharSequence)className, (CharSequence)value))).collect(Collectors.joining(" "));
            }
            result = StringUtils.isBlank((CharSequence)classes) ? parameters.remove("class") : parameters.setParameter("class", classes);
        }
        return result;
    }

    protected WikiParameters removeFreestanding(WikiParameters parameters) {
        return this.removeClass(parameters, "wikimodel-freestanding");
    }

    protected WikiParameters removeMeaningfulParameters(WikiParameters parameters) {
        return this.removeFreestanding(parameters).remove("href");
    }
}

