/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.chaining.LookaheadChainingListener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.syntax.Syntax;

public class StackingFigureContentChainingListener
extends LookaheadChainingListener {
    private static final String CLASS_PARAMETER = "class";
    private boolean isStacking;
    private int numImages;
    private int captionDepth;
    private int figureDepth;
    private int numLinks;
    private boolean cleanImageFigure;
    private ResourceReference imageReference;
    private Map<String, String> imageParameters;
    private ResourceReference linkReference;
    private Map<String, String> linkParameters;

    public StackingFigureContentChainingListener(ListenerChain listenerChain) {
        super(listenerChain, Integer.MAX_VALUE);
        this.setListenerChain(listenerChain);
        this.isStacking = true;
    }

    public void beginFigureCaption(Map<String, String> parameters) {
        super.beginFigureCaption(parameters);
        ++this.captionDepth;
        if (this.captionDepth > 1) {
            this.stopStacking(false);
        }
    }

    public void endFigureCaption(Map<String, String> parameters) {
        super.endFigureCaption(parameters);
        --this.captionDepth;
    }

    public void onImage(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        super.onImage(reference, freestanding, parameters);
        this.internalOnImage(reference, freestanding, parameters);
    }

    public void onImage(ResourceReference reference, boolean freestanding, String id, Map<String, String> parameters) {
        super.onImage(reference, freestanding, id, parameters);
        this.internalOnImage(reference, freestanding, parameters);
    }

    private void internalOnImage(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        if (this.captionDepth == 0) {
            ++this.numImages;
            if (this.numImages > 1 || freestanding) {
                this.stopStacking(false);
            } else {
                this.imageReference = reference;
                this.imageParameters = parameters;
            }
        }
    }

    public void beginFigure(Map<String, String> parameters) {
        super.beginFigure(parameters);
        ++this.figureDepth;
        if (this.figureDepth > 1 || !parameters.containsKey(CLASS_PARAMETER) || !Arrays.asList(StringUtils.split((String)parameters.get(CLASS_PARAMETER))).contains("image")) {
            this.stopStacking(false);
        }
    }

    public void beginTable(Map<String, String> parameters) {
        super.beginTable(parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginTableRow(Map<String, String> parameters) {
        super.beginTableRow(parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginTableCell(Map<String, String> parameters) {
        super.beginTableCell(parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        super.beginTableHeadCell(parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        super.beginDefinitionList(parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginDefinitionTerm() {
        super.beginDefinitionTerm();
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginDefinitionDescription() {
        super.beginDefinitionDescription();
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginList(ListType type, Map<String, String> parameters) {
        super.beginList(type, parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginListItem() {
        super.beginListItem();
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginListItem(Map<String, String> parameters) {
        super.beginListItem(parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        super.beginHeader(level, id, parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginQuotation(Map<String, String> parameters) {
        super.beginQuotation(parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginQuotationLine() {
        super.beginQuotationLine();
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        super.beginLink(reference, freestanding, parameters);
        if (this.captionDepth == 0 && this.isStacking) {
            if (!freestanding && this.numLinks == 0 && this.numImages == 0) {
                this.linkReference = reference;
                this.linkParameters = parameters;
                ++this.numLinks;
            } else {
                this.stopStacking(false);
            }
        }
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        super.endLink(reference, freestanding, parameters);
        if (this.captionDepth == 0 && this.numImages == 0) {
            this.stopStacking(false);
        }
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        super.beginMacroMarker(name, parameters, content, isInline);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void beginMetaData(MetaData metadata) {
        super.beginMetaData(metadata);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        super.onHorizontalLine(parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void onWord(String word) {
        super.onWord(word);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean inline) {
        super.onMacro(id, parameters, content, inline);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void onRawText(String text, Syntax syntax) {
        super.onRawText(text, syntax);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void onSpecialSymbol(char symbol) {
        super.onSpecialSymbol(symbol);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        super.onVerbatim(content, inline, parameters);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void onId(String name) {
        super.onId(name);
        if (this.captionDepth == 0) {
            this.stopStacking(false);
        }
    }

    public void endFigure(Map<String, String> parameters) {
        super.endFigure(parameters);
        if (this.numImages == 1) {
            this.stopStacking(true);
        }
    }

    public boolean isCleanImageFigure() {
        return this.cleanImageFigure;
    }

    public Map<String, String> getImageParameters() {
        return this.imageParameters;
    }

    public ResourceReference getImageReference() {
        return this.imageReference;
    }

    public boolean isWrappedInLink() {
        return this.numLinks > 0;
    }

    public ResourceReference getLinkReference() {
        return this.linkReference;
    }

    public Map<String, String> getLinkParameters() {
        return this.linkParameters;
    }

    protected void stopStacking(boolean isCleanImageFigure) {
        if (this.isStacking) {
            this.isStacking = false;
            this.cleanImageFigure = isCleanImageFigure;
            this.setLookaheadDepth(0);
            LookaheadChainingListener listener = (LookaheadChainingListener)this.getListenerChain().getListener(LookaheadChainingListener.class);
            QueueListener previousEvents = this.getPreviousEvents();
            listener.transferStart(previousEvents);
        }
    }
}

