/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml5;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.wikimodel.WikiModelStreamParser;
import org.xwiki.rendering.internal.parser.xhtml.XHTMLParser;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiCommentHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiDivTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiHeaderTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiIgnoredTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiImageTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiReferenceTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiTableDataTagHandler;
import org.xwiki.rendering.internal.parser.xhtml5.wikimodel.XHTML5SpanTagHandler;
import org.xwiki.rendering.internal.parser.xhtml5.wikimodel.XWikiFigcaptionTagHandler;
import org.xwiki.rendering.internal.parser.xhtml5.wikimodel.XWikiFigureTagHandler;
import org.xwiki.rendering.internal.xhtml5.XHTML5SyntaxProvider;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.wikimodel.IWikiParser;
import org.xwiki.rendering.wikimodel.xhtml.XhtmlParser;
import org.xwiki.rendering.wikimodel.xhtml.handler.CommentHandler;
import org.xwiki.xml.XMLReaderFactory;

@Component
@Named(value="xhtml/5")
public class XHTML5Parser
extends XHTMLParser {
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceParser xhtmlMarkerResourceReferenceParser;
    @Inject
    @Named(value="xwiki")
    private XMLReaderFactory xmlReaderFactory;

    public Syntax getSyntax() {
        return XHTML5SyntaxProvider.XHTML_5;
    }

    public IWikiParser createWikiModelParser() throws ParseException {
        HashMap<String, Object> handlers = new HashMap<String, Object>();
        XWikiHeaderTagHandler handler = new XWikiHeaderTagHandler();
        handlers.put("h1", handler);
        handlers.put("h2", handler);
        handlers.put("h3", handler);
        handlers.put("h4", handler);
        handlers.put("h5", handler);
        handlers.put("h6", handler);
        handlers.put("a", new XWikiReferenceTagHandler((WikiModelStreamParser)this));
        handlers.put("img", new XWikiImageTagHandler());
        handlers.put("span", (Object)new XHTML5SpanTagHandler(this.componentManager, this));
        XWikiDivTagHandler divHandler = new XWikiDivTagHandler("xwiki-document", this.componentManager, (XHTMLParser)this);
        handlers.put("div", divHandler);
        handlers.put("th", new XWikiTableDataTagHandler());
        handlers.put("figure", (Object)new XWikiFigureTagHandler());
        handlers.put("figcaption", (Object)new XWikiFigcaptionTagHandler());
        handlers.put("head", new XWikiIgnoredTagHandler("head"));
        handlers.put("script", new XWikiIgnoredTagHandler("script"));
        XhtmlParser parser = new XhtmlParser();
        parser.setExtraHandlers(handlers);
        parser.setCommentHandler((CommentHandler)new XWikiCommentHandler(this.componentManager, (XHTMLParser)this, this.xhtmlMarkerResourceReferenceParser));
        try {
            parser.setXmlReader(this.xmlReaderFactory.createXMLReader());
        }
        catch (Exception e) {
            throw new ParseException("Failed to create XML reader", (Throwable)e);
        }
        return parser;
    }
}

