/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.wikimodel;

import java.io.Reader;
import java.io.StringReader;
import org.xwiki.rendering.listener.InlineFilterListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.util.ParserUtils;

public class WikiModelParserUtils
extends ParserUtils {
    public void parseInline(StreamParser parser, String content, Listener listener) throws ParseException {
        this.parseInline(parser, content, listener, null, false);
    }

    public void parseInline(StreamParser parser, String content, Listener listener, IdGenerator idGenerator, boolean prefix) throws ParseException {
        Object contentToParse;
        InlineFilterListener inlineFilterListener;
        if (prefix) {
            inlineFilterListener = new PrefixIgnoredInlineFilterListener();
            contentToParse = "wikimarker " + content;
        } else {
            inlineFilterListener = new InlineFilterListener();
            contentToParse = content;
        }
        inlineFilterListener.setWrappedListener(listener);
        if (idGenerator != null) {
            parser.parse((Reader)new StringReader((String)contentToParse), (Listener)inlineFilterListener, idGenerator);
        } else {
            parser.parse((Reader)new StringReader((String)contentToParse), (Listener)inlineFilterListener);
        }
    }

    private final class PrefixIgnoredInlineFilterListener
    extends InlineFilterListener {
        private boolean foundWord;
        private boolean foundSpace;

        private PrefixIgnoredInlineFilterListener() {
        }

        public void onWord(String word) {
            if (this.foundWord) {
                super.onWord(word);
            } else {
                this.foundWord = true;
            }
        }

        public void onSpace() {
            if (this.foundSpace) {
                super.onSpace();
            } else {
                this.foundSpace = true;
            }
        }
    }
}

