/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;

@Component(roles={XHTMLMetaDataRenderer.class})
@Singleton
public class XHTMLMetaDataRenderer {
    @Inject
    private ConverterManager converterManager;

    private String getMetadataContainerElement(boolean inline) {
        if (inline) {
            return "span";
        }
        return "div";
    }

    public void beginRender(XHTMLWikiPrinter printer, boolean inline, MetaData metaData) {
        LinkedHashMap<Object, String> attributes = new LinkedHashMap<Object, String>();
        for (Map.Entry metadataPair : metaData.getMetaData().entrySet()) {
            String value = (String)this.converterManager.convert(String.class, metadataPair.getValue());
            attributes.put("data-xwiki-" + (String)metadataPair.getKey(), value);
        }
        attributes.put("class", "xwiki-metadata-container");
        printer.printXMLStartElement(this.getMetadataContainerElement(inline), attributes);
    }

    public void endRender(XHTMLWikiPrinter printer, boolean inline) {
        printer.printXMLEndElement(this.getMetadataContainerElement(inline));
    }
}

