/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.toc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ListBLock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.NumberedListBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.internal.macro.toc.TocBlockFilter;
import org.xwiki.rendering.internal.macro.toc.TreeParameters;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.macro.toc.TocEntriesResolver;
import org.xwiki.rendering.macro.toc.TocEntryExtension;

public class TocTreeBuilder {
    private static final String CLASS_PARAMETER = "class";
    private TocBlockFilter tocBlockFilter;
    private TocEntriesResolver tocEntriesResolver;
    private List<TocEntryExtension> extensions;

    public TocTreeBuilder(TocBlockFilter tocBlockFilter, TocEntriesResolver tocEntriesResolver, List<TocEntryExtension> extensions) {
        this.tocBlockFilter = tocBlockFilter;
        this.tocEntriesResolver = tocEntriesResolver;
        this.extensions = extensions;
    }

    public List<Block> build(TreeParameters parameters) {
        Block tocBlock;
        Block block;
        List<HeaderBlock> headers = this.tocEntriesResolver.getBlocks(parameters.rootBlock);
        if (parameters.rootBlock instanceof SectionBlock && (block = (Block)parameters.rootBlock.getChildren().get(0)) instanceof HeaderBlock) {
            headers.remove(block);
        }
        List<Block> result = (tocBlock = this.generateTree(headers, parameters)) != null ? Arrays.asList(tocBlock) : Collections.emptyList();
        return result;
    }

    private Block generateTree(List<HeaderBlock> headers, TreeParameters parameters) {
        Block tocBlock = null;
        int start = parameters.start;
        int depth = parameters.depth;
        boolean numbered = parameters.isNumbered;
        int currentLevel = start - 1;
        Block currentBlock = null;
        for (HeaderBlock headerBlock : headers) {
            int headerLevel = headerBlock.getLevel().getAsInt();
            if (headerLevel < start || headerLevel > depth) continue;
            if (currentLevel < headerLevel) {
                while (currentLevel < headerLevel) {
                    if (currentBlock instanceof ListBLock) {
                        currentBlock = this.addItemBlock(currentBlock, null, parameters);
                    }
                    currentBlock = this.createChildListBlock(numbered, currentBlock);
                    ++currentLevel;
                }
            } else {
                while (currentLevel > headerLevel) {
                    currentBlock = currentBlock.getParent().getParent();
                    --currentLevel;
                }
                currentBlock = currentBlock.getParent();
            }
            currentBlock = this.addItemBlock(currentBlock, headerBlock, parameters);
        }
        if (currentBlock != null) {
            tocBlock = currentBlock.getRoot();
            tocBlock.setParameter(CLASS_PARAMETER, "wikitoc");
        }
        if (tocBlock != null) {
            this.flagEntriesWithNoDirectChild(tocBlock);
        }
        return tocBlock;
    }

    private Block addItemBlock(Block currentBlock, HeaderBlock headerBlock, TreeParameters parameters) {
        ListItemBlock itemBlock = headerBlock == null ? this.createEmptyTocEntry() : this.createTocEntry(headerBlock, parameters);
        currentBlock.addChild((Block)itemBlock);
        return itemBlock;
    }

    private ListItemBlock createEmptyTocEntry() {
        return new ListItemBlock(Collections.emptyList());
    }

    protected ListItemBlock createTocEntry(HeaderBlock headerBlock, TreeParameters parameters) {
        DocumentResourceReference reference = new DocumentResourceReference(parameters.documentReference);
        String idParameter = headerBlock.getParameter("id");
        if (idParameter != null) {
            reference.setAnchor(idParameter);
        } else {
            reference.setAnchor(headerBlock.getId());
        }
        List<Block> blocks = this.tocBlockFilter.generateLabel(headerBlock);
        for (TocEntryExtension extension : this.extensions) {
            blocks = extension.decorate(headerBlock, blocks, parameters.rootBlock, this.tocEntriesResolver);
        }
        LinkBlock linkBlock = new LinkBlock(blocks, (ResourceReference)reference, false);
        return new ListItemBlock(Collections.singletonList(linkBlock));
    }

    private ListBLock createChildListBlock(boolean numbered, Block parentBlock) {
        NumberedListBlock childListBlock;
        Object object = childListBlock = numbered ? new NumberedListBlock(Collections.emptyList()) : new BulletedListBlock(Collections.emptyList());
        if (parentBlock != null) {
            parentBlock.addChild((Block)childListBlock);
        }
        return childListBlock;
    }

    private void flagEntriesWithNoDirectChild(Block tocBlock) {
        tocBlock.getBlocks(block -> block instanceof ListItemBlock && block.getChildren().size() == 1 && !(block.getChildren().get(0) instanceof LinkBlock), Block.Axes.DESCENDANT).forEach(listBlock -> listBlock.setParameter(CLASS_PARAMETER, ((String)StringUtils.defaultIfEmpty((CharSequence)listBlock.getParameter(CLASS_PARAMETER), (CharSequence)"") + " nodirectchild").trim()));
    }
}

