/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.footnote;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.NumberedListBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MacroMarkerBlockMatcher;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.footnote.FootnoteMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.IdGenerator;

@Component
@Named(value="putFootnotes")
@Singleton
public class PutFootnotesMacro
extends AbstractMacro<FootnoteMacroParameters> {
    public static final String MACRO_NAME = "putFootnotes";
    private static final String DESCRIPTION = "Displays the footnotes defined so far. If missing, all footnotes are displayed by default at the end of the page.";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String FOOTNOTE_ID_PREFIX = "x_footnote_";
    private static final String FOOTNOTE_REFERENCE_ID_PREFIX = "x_footnote_ref_";
    private static final String FOOTNOTE_REF_CLASS_NAME = "footnoteRef";
    @Inject
    private Logger logger;

    public PutFootnotesMacro() {
        super("Put Footnote", DESCRIPTION, FootnoteMacroParameters.class);
        this.setDefaultCategories(Set.of("Content"));
        this.setPriority(2001);
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(FootnoteMacroParameters parameters, String content, MacroTransformationContext context) {
        List<Block> result = Collections.emptyList();
        Block footnoteAncestor = context.getCurrentMacroBlock().getFirstBlock((BlockMatcher)new MacroMarkerBlockMatcher(new String[]{MACRO_NAME, "footnote"}), Block.Axes.ANCESTOR);
        if (footnoteAncestor != null) {
            return result;
        }
        XDOM root = context.getXDOM();
        List macroMarkerBlocks = root.getBlocks((BlockMatcher)new MacroMarkerBlockMatcher(new String[]{MACRO_NAME, "footnote"}), Block.Axes.DESCENDANT);
        LinkedHashMap footnotes = new LinkedHashMap();
        AtomicInteger temporaryId = new AtomicInteger(0);
        macroMarkerBlocks.stream().filter(macro -> "footnote".equals(macro.getId())).map(Footnote::new).forEach(footnote -> footnotes.put(Objects.requireNonNullElseGet(footnote.id, () -> String.valueOf(temporaryId.getAndIncrement())), footnote));
        macroMarkerBlocks.stream().filter(macro -> MACRO_NAME.equals(macro.getId())).forEach(macro -> this.collectFootnoteContents((MacroMarkerBlock)macro, footnotes));
        IdGenerator idGenerator = null;
        if (context.getXDOM() != null) {
            idGenerator = context.getXDOM().getIdGenerator();
        }
        if (!footnotes.isEmpty()) {
            NumberedListBlock container = new NumberedListBlock(Collections.emptyList());
            container.setParameter(CLASS_ATTRIBUTE_NAME, "footnotes");
            result = Collections.singletonList(container);
            int counter = 1;
            for (Footnote footnote2 : footnotes.values()) {
                if (footnote2.content != null) {
                    ListItemBlock footnoteResult = this.processFootnote(footnote2, counter, idGenerator);
                    container.addChild((Block)footnoteResult);
                    ++counter;
                    continue;
                }
                this.logger.warn("No content for footnote [{}] found, ignoring it.", (Object)footnote2.macroMarkerBlock);
            }
        }
        return result;
    }

    private void collectFootnoteContents(MacroMarkerBlock macro, Map<String, Footnote> footnotes) {
        if (macro.getChildren().size() == 1 && macro.getChildren().get(0) instanceof NumberedListBlock) {
            for (Block listItemBlock : ((Block)macro.getChildren().get(0)).getChildren()) {
                if (listItemBlock.getChildren().size() != 3 || !(listItemBlock.getChildren().get(2) instanceof CompositeBlock) || !StringUtils.startsWith((CharSequence)((Block)listItemBlock.getChildren().get(0)).getParameter(ID_ATTRIBUTE_NAME), (CharSequence)FOOTNOTE_ID_PREFIX)) continue;
                CompositeBlock footnoteContent = (CompositeBlock)listItemBlock.getChildren().get(2);
                String id = ((Block)listItemBlock.getChildren().get(0)).getParameter(ID_ATTRIBUTE_NAME);
                if (footnotes.containsKey(id)) {
                    footnotes.get((Object)id).content = footnoteContent;
                    continue;
                }
                this.logger.warn("Could not find footnote marker for footnote [{}], ignoring it.", (Object)footnoteContent);
            }
        }
        macro.getParent().removeBlock((Block)macro);
    }

    private ListItemBlock processFootnote(Footnote footnote, int counter, IdGenerator idGenerator) {
        if (footnote.referenceId == null) {
            footnote.referenceId = this.generateId(counter, FOOTNOTE_REFERENCE_ID_PREFIX, idGenerator);
        }
        if (footnote.id == null) {
            footnote.id = this.generateId(counter, FOOTNOTE_ID_PREFIX, idGenerator);
        }
        Block referenceBlock = this.createFootnoteReferenceBlock(counter, footnote.id, footnote.referenceId);
        ListItemBlock footnoteBlock = this.createFootnoteBlock(footnote.content, footnote.id, footnote.referenceId);
        this.addFootnoteRef(footnote.macroMarkerBlock, referenceBlock);
        return footnoteBlock;
    }

    private String generateId(int counter, String idPrefix, IdGenerator idGenerator) {
        Object footnoteId = idPrefix + counter;
        if (idGenerator != null) {
            footnoteId = idGenerator.generateUniqueId(((String)footnoteId).substring(0, 1), ((String)footnoteId).substring(1));
        }
        return footnoteId;
    }

    private void addFootnoteRef(MacroMarkerBlock footnoteMacro, Block footnoteRef) {
        footnoteMacro.getChildren().clear();
        if (footnoteMacro.isInline()) {
            footnoteMacro.addChild(footnoteRef);
        } else {
            footnoteMacro.addChild((Block)new ParagraphBlock(List.of(footnoteRef)));
        }
    }

    private Block createFootnoteReferenceBlock(int counter, String footnoteId, String referenceId) {
        WordBlock result = new WordBlock(String.valueOf(counter));
        DocumentResourceReference reference = new DocumentResourceReference(null);
        reference.setAnchor(footnoteId);
        result = new LinkBlock(Collections.singletonList(result), (ResourceReference)reference, false);
        result = new FormatBlock(Collections.singletonList(result), Format.SUPERSCRIPT);
        result.setParameter(ID_ATTRIBUTE_NAME, referenceId);
        result.setParameter(CLASS_ATTRIBUTE_NAME, FOOTNOTE_REF_CLASS_NAME);
        return result;
    }

    private ListItemBlock createFootnoteBlock(CompositeBlock content, String footnoteId, String referenceId) {
        WordBlock result = new WordBlock("^");
        DocumentResourceReference reference = new DocumentResourceReference(null);
        reference.setAnchor(referenceId);
        result = new LinkBlock(Collections.singletonList(result), (ResourceReference)reference, false);
        result.setParameter(ID_ATTRIBUTE_NAME, footnoteId);
        result.setParameter(CLASS_ATTRIBUTE_NAME, "footnoteBackRef");
        result = new ListItemBlock(Collections.singletonList(result));
        result.addChild((Block)new SpaceBlock());
        result.addChild((Block)content);
        return (ListItemBlock)result;
    }

    private static class Footnote {
        private String id;
        private String referenceId;
        private final MacroMarkerBlock macroMarkerBlock;
        private CompositeBlock content;

        Footnote(MacroMarkerBlock macroMarkerBlock) {
            this.macroMarkerBlock = macroMarkerBlock;
            List footnoteContent = macroMarkerBlock.getChildren();
            if (!macroMarkerBlock.isInline() && footnoteContent.size() == 1 && footnoteContent.get(0) instanceof ParagraphBlock) {
                footnoteContent = ((Block)footnoteContent.get(0)).getChildren();
            }
            if (footnoteContent.size() == 1 && footnoteContent.get(0) instanceof FormatBlock && StringUtils.startsWith((CharSequence)((Block)footnoteContent.get(0)).getParameter(PutFootnotesMacro.ID_ATTRIBUTE_NAME), (CharSequence)PutFootnotesMacro.FOOTNOTE_REFERENCE_ID_PREFIX)) {
                LinkBlock linkBlock;
                ResourceReference reference;
                Block formatBlock = (Block)footnoteContent.get(0);
                if (!formatBlock.getChildren().isEmpty() && formatBlock.getChildren().get(0) instanceof LinkBlock && (reference = (linkBlock = (LinkBlock)formatBlock.getChildren().get(0)).getReference()) instanceof DocumentResourceReference) {
                    this.id = ((DocumentResourceReference)reference).getAnchor();
                }
                this.referenceId = formatBlock.getParameter(PutFootnotesMacro.ID_ATTRIBUTE_NAME);
            } else {
                this.content = new CompositeBlock(footnoteContent);
            }
        }
    }
}

