/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.content;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.converter.Converter;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.content.ContentMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.source.MacroContentWikiSource;
import org.xwiki.rendering.macro.source.MacroContentWikiSourceFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="content")
@Singleton
public class ContentMacro
extends AbstractMacro<ContentMacroParameters> {
    private static final String DESCRIPTION = "Allows writing content in any wiki markup";
    private static final String CONTENT_DESCRIPTION = "The content to execute";
    @Inject
    private MacroContentWikiSourceFactory contentFactory;
    @Inject
    private MacroContentParser macroContentParser;
    @Inject
    private Converter<Syntax> syntaxConverter;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public ContentMacro() {
        super("Content", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, false, Block.LIST_BLOCK_TYPE), ContentMacroParameters.class);
        this.setDefaultCategories(Set.of("Content"));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(ContentMacroParameters parameters, String macroContent, MacroTransformationContext context) throws MacroExecutionException {
        Syntax syntax = parameters.getSyntax();
        String content = macroContent;
        MetaData metadata = new MetaData();
        if (syntax != null) {
            metadata.addMetaData("syntax", (Object)syntax);
        }
        if (parameters.getSource() != null) {
            MacroContentWikiSource wikiSource = this.contentFactory.getContent(parameters.getSource(), context);
            if (syntax == null) {
                syntax = wikiSource.getSyntax();
            }
            content = wikiSource.getContent();
        } else {
            metadata.addMetaData(this.getNonGeneratedContentMetaData());
        }
        XDOM xdom = this.macroContentParser.parse(content, syntax, context, false, metadata, context.isInline());
        return List.of(new MetaDataBlock(xdom.getChildren(), xdom.getMetaData()));
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        Syntax syntax = null;
        String syntaxString = macroBlock.getParameter("syntax");
        if (syntaxString != null) {
            syntax = (Syntax)this.syntaxConverter.convert(Syntax.class, (Object)syntaxString);
        }
        this.macroContentParser.prepareContentWiki(macroBlock, syntax);
    }

    public boolean isExecutionIsolated(ContentMacroParameters parameters, String content) {
        return true;
    }
}

