/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.box;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.box.BoxMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

public abstract class AbstractBoxMacro<P extends BoxMacroParameters>
extends AbstractMacro<P> {
    public static final String CONTENT_MISSING_ERROR = "The required content is missing.";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    @Inject
    protected MacroContentParser contentParser;
    @Inject
    @Named(value="image/untyped")
    private ResourceReferenceParser untypedImageReferenceParser;

    protected AbstractBoxMacro(String name, String description, ContentDescriptor contentDescriptor, Class<?> parametersBeanClass) {
        super(name, description, contentDescriptor, parametersBeanClass);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected List<? extends Block> getBlockTitle(P parameters, String content, MacroTransformationContext context) {
        return ((BoxMacroParameters)parameters).getBlockTitle();
    }

    protected ResourceReference getImageReference(P parameters, String content, MacroTransformationContext context) {
        ResourceReference imageReference = ((BoxMacroParameters)parameters).getImage();
        if (imageReference != null && imageReference.getType().equals((Object)ResourceType.UNKNOWN)) {
            imageReference = this.untypedImageReferenceParser.parse(imageReference.getReference());
        }
        return imageReference;
    }

    protected String getTitle(P parameters, String content, MacroTransformationContext context) {
        return ((BoxMacroParameters)parameters).getTitle();
    }

    protected Map<String, String> getBoxParameters(P parameters, String content, MacroTransformationContext context) {
        LinkedHashMap<String, String> boxParameters = new LinkedHashMap<String, String>();
        String classParameter = ((BoxMacroParameters)parameters).getCssClass();
        String cssClass = StringUtils.isEmpty((CharSequence)classParameter) ? this.getClassProperty() : this.getClassProperty() + " " + classParameter;
        boxParameters.put(CLASS_ATTRIBUTE_NAME, cssClass);
        if (!StringUtils.isEmpty((CharSequence)((BoxMacroParameters)parameters).getWidth())) {
            boxParameters.put("style", "width:" + ((BoxMacroParameters)parameters).getWidth());
        }
        return boxParameters;
    }

    public List<Block> execute(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        Block boxBlock = new BoxBlockBuilder().setParameters(parameters).setContent(content).setContext(context).setBoxParameters(this.getBoxParameters(parameters, content, context)).setImageReference(this.getImageReference(parameters, content, context)).setTitleParameter(this.getTitle(parameters, content, context)).setTitleBlockList(this.getBlockTitle(parameters, content, context)).build();
        if (boxBlock == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(boxBlock);
    }

    protected abstract List<Block> parseContent(P var1, String var2, MacroTransformationContext var3) throws MacroExecutionException;

    protected boolean isContentChecked() {
        return true;
    }

    protected String getClassProperty() {
        return "box";
    }

    protected MacroContentParser getMacroContentParser() {
        return this.contentParser;
    }

    private final class BoxBlockBuilder {
        private P parameters;
        private String content;
        private MacroTransformationContext context;
        private Map<String, String> boxParameters;
        private ResourceReference imageReference;
        private String titleParameter;
        private List<? extends Block> titleBlockList;

        private BoxBlockBuilder() {
        }

        public BoxBlockBuilder setParameters(P parameters) {
            this.parameters = parameters;
            return this;
        }

        public BoxBlockBuilder setContent(String content) {
            this.content = content;
            return this;
        }

        public BoxBlockBuilder setContext(MacroTransformationContext context) {
            this.context = context;
            return this;
        }

        public BoxBlockBuilder setBoxParameters(Map<String, String> boxParameters) {
            this.boxParameters = boxParameters;
            return this;
        }

        public BoxBlockBuilder setImageReference(ResourceReference imageReference) {
            this.imageReference = imageReference;
            return this;
        }

        public BoxBlockBuilder setTitleParameter(String titleParameter) {
            this.titleParameter = titleParameter;
            return this;
        }

        public BoxBlockBuilder setTitleBlockList(List<? extends Block> titleBlockList) {
            this.titleBlockList = titleBlockList;
            return this;
        }

        public Block build() throws MacroExecutionException {
            GroupBlock ret = null;
            if (StringUtils.isEmpty((CharSequence)this.content) && AbstractBoxMacro.this.getDescriptor().getContentDescriptor().isMandatory()) {
                throw new MacroExecutionException(AbstractBoxMacro.CONTENT_MISSING_ERROR);
            }
            if (AbstractBoxMacro.this.isContentChecked() && this.content == null) {
                return ret;
            }
            List<Block> contentBlocks = AbstractBoxMacro.this.parseContent(this.parameters, this.content, this.context);
            if (contentBlocks == null) {
                return null;
            }
            if (this.context.isInline()) {
                FormatBlock spanBlock = new FormatBlock(contentBlocks, Format.NONE);
                spanBlock.setParameters(this.boxParameters);
                ret = spanBlock;
            } else {
                ret = new GroupBlock(this.boxParameters);
                if (this.imageReference != null) {
                    ImageBlock imageBlock = new ImageBlock(this.imageReference, true);
                    ret.addChild((Block)imageBlock);
                    ret.addChild((Block)new NewLineBlock());
                }
                if (!StringUtils.isEmpty((CharSequence)this.titleParameter)) {
                    List titleContentBlock = AbstractBoxMacro.this.contentParser.parse(this.titleParameter, this.context, false, true).getChildren();
                    List<MetaDataBlock> titleMetadata = List.of(new MetaDataBlock(titleContentBlock, AbstractBoxMacro.this.getNonGeneratedContentMetaData("title")));
                    GroupBlock titleBlock = new GroupBlock(titleMetadata);
                    titleBlock.setParameter(AbstractBoxMacro.CLASS_ATTRIBUTE_NAME, "box-title");
                    ret.addChildren(List.of(titleBlock));
                }
                if (this.titleBlockList != null) {
                    ret.addChildren(this.titleBlockList);
                }
                ret.addChildren(contentBlocks);
            }
            return ret;
        }
    }
}

