/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.properties.BeanManager;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.AbstractMacroAspect;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.descriptor.AbstractMacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultMacroDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultParameterDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;

public abstract class AbstractMacro<P>
implements Macro<P>,
Initializable {
    public static final String DEFAULT_CATEGORY_FORMATTING = "Formatting";
    public static final String DEFAULT_CATEGORY_DEVELOPMENT = "Development";
    public static final String DEFAULT_CATEGORY_CONTENT = "Content";
    public static final String DEFAULT_CATEGORY_NAVIGATION = "Navigation";
    public static final String DEFAULT_CATEGORY_INTERNAL = "Internal";
    public static final String DEFAULT_CATEGORY_DEPRECATED = "Deprecated";
    public static final String DEFAULT_CATEGORY_LAYOUT = "Layout";
    @Inject
    protected BeanManager beanManager;
    @Inject
    private ComponentDescriptor<Macro> componentDescriptor;
    private String name;
    private String description;
    private ContentDescriptor contentDescriptor;
    private Class<?> parametersBeanClass;
    private MacroDescriptor macroDescriptor;
    private int priority = 1000;
    private Set<String> defaultCategories;

    public AbstractMacro(String name) {
        this(name, null);
    }

    public AbstractMacro(String name, String description) {
        this(name, description, null, Object.class);
    }

    public AbstractMacro(String name, String description, ContentDescriptor contentDescriptor) {
        this(name, description, contentDescriptor, Object.class);
    }

    public AbstractMacro(String name, String description, Class<?> parametersBeanClass) {
        this(name, description, null, parametersBeanClass);
    }

    public AbstractMacro(String name, String description, ContentDescriptor contentDescriptor, Class<?> parametersBeanClass) {
        this.name = name;
        this.description = description;
        this.contentDescriptor = contentDescriptor;
        this.parametersBeanClass = parametersBeanClass;
    }

    public void initialize() throws InitializationException {
        MacroId macroId = new MacroId(this.componentDescriptor.getRoleHint());
        DefaultMacroDescriptor descriptor = new DefaultMacroDescriptor(macroId, this.name, this.description, this.contentDescriptor, this.beanManager.getBeanDescriptor(this.parametersBeanClass));
        descriptor.setDefaultCategories(this.defaultCategories);
        descriptor.setSupportsInlineMode(this.supportsInlineMode());
        this.setDescriptor(descriptor);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public MacroDescriptor getDescriptor() {
        return this.macroDescriptor;
    }

    @Override
    public int compareTo(Macro<?> macro) {
        return this.getPriority() - macro.getPriority();
    }

    protected void setDescriptor(MacroDescriptor descriptor) {
        this.macroDescriptor = descriptor;
    }

    protected void setDefaultCategories(Set<String> defaultCategories) {
        this.defaultCategories = defaultCategories;
        if (this.getDescriptor() instanceof AbstractMacroDescriptor) {
            ((AbstractMacroDescriptor)this.getDescriptor()).setDefaultCategories(defaultCategories);
        }
    }

    public static MetaData getNonGeneratedContentMetaData(ContentDescriptor contentDescriptor) {
        MetaData metaData = new MetaData();
        Type contentType = contentDescriptor != null ? contentDescriptor.getType() : DefaultContentDescriptor.DEFAULT_CONTENT_TYPE;
        String converted = ReflectionUtils.serializeType((Type)contentType);
        metaData.addMetaData("non-generated-content", (Object)converted);
        return metaData;
    }

    protected MetaData getNonGeneratedContentMetaData() {
        return AbstractMacro.getNonGeneratedContentMetaData(this.contentDescriptor);
    }

    public static MetaData getNonGeneratedContentMetaData(Map<String, ParameterDescriptor> parameterDescriptorMap, String name) {
        MetaData metaData = new MetaData();
        Type contentType = parameterDescriptorMap != null && parameterDescriptorMap.containsKey(name) ? parameterDescriptorMap.get(name).getDisplayType() : DefaultParameterDescriptor.DEFAULT_PARAMETER_TYPE;
        String converted = ReflectionUtils.serializeType((Type)contentType);
        metaData.addMetaData("non-generated-content", (Object)converted);
        metaData.addMetaData("parameter-name", (Object)name);
        return metaData;
    }

    protected MetaData getNonGeneratedContentMetaData(String parameterName) {
        MetaData result = this.macroDescriptor != null ? AbstractMacro.getNonGeneratedContentMetaData(this.macroDescriptor.getParameterDescriptorMap(), parameterName) : AbstractMacro.getNonGeneratedContentMetaData(null, parameterName);
        return result;
    }

    public /* synthetic */ void ajc$protectedDispatch$org_xwiki_rendering_macro_AbstractMacro$setDefaultCategories(Set set) {
        this.setDefaultCategories(set);
    }

    @Deprecated(since="14.6RC1")
    public void setDefaultCategory(String string) {
        AbstractMacroAspect.ajc$interMethod$org_xwiki_rendering_macro_AbstractMacroAspect$org_xwiki_rendering_macro_AbstractMacro$setDefaultCategory(this, string);
    }
}

