/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;

@Component(roles={IsolatedExecutionConfiguration.class})
@Singleton
public class IsolatedExecutionConfiguration {
    @Inject
    @Named(value="restricted")
    private Provider<ConfigurationSource> configurationSourceProvider;
    private final Map<String, Optional<Boolean>> cache = new ConcurrentHashMap<String, Optional<Boolean>>();

    public boolean isExecutionIsolated(String macroId, boolean defaultValue) {
        return this.cache.computeIfAbsent(macroId, k -> Optional.ofNullable((Boolean)((ConfigurationSource)this.configurationSourceProvider.get()).getProperty("rendering.macro." + k + ".executionIsolated", Boolean.class, null))).orElse(defaultValue);
    }
}

