/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.macro.RawBlockFilter;
import org.xwiki.rendering.transformation.macro.RawBlockFilterParameters;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Singleton
@Named(value="html")
public class HTMLRawBlockFilter
implements RawBlockFilter {
    private static final Pattern TOP_LEVEL_HTML = Pattern.compile("\\A\\s(<html>).*", 32);
    @Inject
    private HTMLCleaner htmlCleaner;

    @Override
    public RawBlock filter(RawBlock block, RawBlockFilterParameters parameters) throws MacroExecutionException {
        boolean restricted;
        RawBlock result = block;
        MacroTransformationContext macroTransformationContext = parameters.getMacroTransformationContext();
        boolean bl = restricted = parameters.isRestricted() || macroTransformationContext != null && macroTransformationContext.getTransformationContext().isRestricted();
        if (SyntaxType.HTML_FAMILY_TYPES.contains(block.getSyntax().getType()) && parameters.isClean() || restricted) {
            String cleanedContent = this.cleanHTML(block.getRawContent(), macroTransformationContext, restricted, block.getSyntax());
            result = new RawBlock(cleanedContent, block.getSyntax());
        }
        return result;
    }

    private String cleanHTML(String content, MacroTransformationContext context, boolean restricted, Syntax targetSyntax) throws MacroExecutionException {
        String cleanedContent = content;
        HTMLCleanerConfiguration cleanerConfiguration = this.getCleanerConfiguration(restricted, targetSyntax);
        Document document = this.htmlCleaner.clean((Reader)new StringReader(cleanedContent), cleanerConfiguration);
        HTMLUtils.stripHTMLEnvelope((Document)document);
        if (context.isInline()) {
            Element root = document.getDocumentElement();
            if (root.getChildNodes().getLength() == 1 && root.getFirstChild().getNodeType() == 1 && root.getFirstChild().getNodeName().equalsIgnoreCase("p")) {
                HTMLUtils.stripFirstElementInside((Document)document, (String)"html", (String)"p");
            } else {
                throw new MacroExecutionException("When using HTML content inline, you can only use inline HTML content. Block HTML content (such as tables) cannot be displayed. Try leaving an empty line before and after the macro.");
            }
        }
        if (TOP_LEVEL_HTML.matcher(cleanedContent = HTMLUtils.toString((Document)document, (boolean)true, (boolean)true)).matches()) {
            cleanedContent = cleanedContent.substring(7, cleanedContent.length() - ("</html>".length() + 1));
        }
        return cleanedContent;
    }

    private HTMLCleanerConfiguration getCleanerConfiguration(boolean restricted, Syntax targetSyntax) {
        HTMLCleanerConfiguration cleanerConfiguration = this.htmlCleaner.getDefaultConfiguration();
        HashMap<String, String> parameters = new HashMap<String, String>(cleanerConfiguration.getParameters());
        if (Syntax.HTML_5_0.equals((Object)targetSyntax) || Syntax.ANNOTATED_HTML_5_0.equals((Object)targetSyntax)) {
            parameters.put("htmlVersion", "5");
        }
        if (restricted) {
            parameters.put("restricted", "true");
        }
        cleanerConfiguration.setParameters(parameters);
        return cleanerConfiguration;
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

