/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.source;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.rendering.macro.source.MacroContentSourceReference;

@Component
@Singleton
public class MacroContentSourceReferenceConverter
extends AbstractConverter<MacroContentSourceReference> {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;

    protected MacroContentSourceReference convertToType(Type targetType, Object value) {
        if (value == null) {
            return null;
        }
        try {
            return this.convertToType(value);
        }
        catch (IOException e) {
            throw new ConversionException("Failed to convert to MacroWikiSourceReference", (Throwable)e);
        }
    }

    private MacroContentSourceReference convertToType(Object value) throws IOException {
        MacroContentSourceReference reference = value instanceof String ? this.fromString((String)value) : (value instanceof InputStream ? new MacroContentSourceReference("string", IOUtils.toString((InputStream)((InputStream)value), (Charset)StandardCharsets.UTF_8)) : (value instanceof byte[] ? new MacroContentSourceReference("string", new String((byte[])value, StandardCharsets.UTF_8)) : (value instanceof Reader ? new MacroContentSourceReference("string", IOUtils.toString((Reader)((Reader)value))) : (value instanceof URL ? new MacroContentSourceReference("url", ((URL)value).toExternalForm()) : (value instanceof File ? new MacroContentSourceReference("file", ((File)value).getAbsolutePath()) : this.fromUnknownType(value))))));
        return reference;
    }

    private MacroContentSourceReference fromUnknownType(Object value) {
        ParameterizedType componentRole = TypeUtils.parameterize(org.xwiki.rendering.macro.source.MacroContentSourceReferenceConverter.class, (Type[])new Type[]{value.getClass()});
        ComponentManager componentManager = (ComponentManager)this.contextComponentManagerProvider.get();
        if (componentManager.hasComponent((Type)componentRole)) {
            try {
                org.xwiki.rendering.macro.source.MacroContentSourceReferenceConverter converter = (org.xwiki.rendering.macro.source.MacroContentSourceReferenceConverter)componentManager.getInstance((Type)componentRole);
                return converter.convert(value);
            }
            catch (ComponentLookupException e) {
                throw new ConversionException("Failed to get the code macro source reference converter component for type [" + String.valueOf(value.getClass()) + "]", (Throwable)e);
            }
        }
        return this.fromString(value.toString());
    }

    private MacroContentSourceReference fromString(String source) {
        int index = source.indexOf(58);
        return new MacroContentSourceReference(index <= 0 ? "string" : source.substring(0, index), index < source.length() ? source.substring(index + 1) : "");
    }
}

