/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.source;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.source.MacroContentSourceReference;
import org.xwiki.rendering.macro.source.MacroContentWikiSource;
import org.xwiki.rendering.macro.source.MacroContentWikiSourceFactory;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Singleton
public class DefaultMacroWikiContentSourceFactory
implements MacroContentWikiSourceFactory {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    public MacroContentWikiSource getContent(MacroContentSourceReference reference, MacroTransformationContext context) throws MacroExecutionException {
        ComponentManager componentManager;
        String type = reference.getType();
        if (type != null && !type.isEmpty() && !type.equals("default") && (componentManager = (ComponentManager)this.componentManagerProvider.get()).hasComponent(MacroContentWikiSourceFactory.class, type)) {
            MacroContentWikiSourceFactory factory;
            try {
                factory = (MacroContentWikiSourceFactory)componentManager.getInstance(MacroContentWikiSourceFactory.class, type);
            }
            catch (ComponentLookupException e) {
                throw new MacroExecutionException("Failed to lookup code macro source factory for [" + type + "]", e);
            }
            return factory.getContent(reference, context);
        }
        throw new MacroExecutionException("Unsupported source type [" + type + "]");
    }
}

