/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.converter;

import java.io.Reader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.converter.ConversionException;
import org.xwiki.rendering.converter.Converter;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Singleton
public class DefaultConverter
implements Converter {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private TransformationManager transformationManager;

    @Override
    public void convert(Reader source, Syntax sourceSyntax, Syntax targetSyntax, WikiPrinter printer) throws ConversionException {
        BlockRenderer renderer;
        XDOM xdom;
        try {
            Parser parser = (Parser)((ComponentManager)this.componentManagerProvider.get()).getInstance(Parser.class, sourceSyntax.toIdString());
            xdom = parser.parse(source);
        }
        catch (ComponentLookupException e) {
            throw new ConversionException("Failed to locate Parser for syntax [" + String.valueOf(sourceSyntax) + "]", e);
        }
        catch (ParseException e) {
            throw new ConversionException("Failed to parse input source", e);
        }
        try {
            TransformationContext context = new TransformationContext(xdom, sourceSyntax);
            context.setTargetSyntax(targetSyntax);
            this.transformationManager.performTransformations((Block)xdom, context);
        }
        catch (TransformationException e) {
            throw new ConversionException("Failed to execute some transformations", e);
        }
        try {
            renderer = (BlockRenderer)((ComponentManager)this.componentManagerProvider.get()).getInstance(BlockRenderer.class, targetSyntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new ConversionException("Failed to locate Renderer for syntax [" + String.valueOf(targetSyntax) + "]", e);
        }
        renderer.render(xdom, printer);
    }
}

