/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.block;

import java.util.ArrayList;
import java.util.List;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.block.MacroMarkerBlock;

public class ProtectedBlockFilter
implements BlockFilter {
    @Override
    public List<Block> filter(Block block) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (!this.isProtectedBlock(block)) {
            blocks.add(block);
        }
        return blocks;
    }

    public List<Block> filter(List<Block> blocks) {
        ArrayList<Block> filteredBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            filteredBlocks.addAll(this.filter(block));
        }
        return filteredBlocks;
    }

    public Block getNextSibling(Block block) {
        Block sibling;
        for (sibling = block.getNextSibling(); sibling != null && this.isProtectedBlock(sibling); sibling = sibling.getNextSibling()) {
        }
        return sibling;
    }

    public <T extends Block> List<T> getChildrenByType(Block block, Class<T> blockClass, boolean recurse) {
        ArrayList<Block> typedBlocks = new ArrayList<Block>();
        for (Block child : this.filter(block.getChildren())) {
            if (blockClass.isAssignableFrom(child.getClass())) {
                typedBlocks.add((Block)blockClass.cast(child));
            }
            if (!recurse || child.getChildren().isEmpty()) continue;
            typedBlocks.addAll(this.getChildrenByType(child, blockClass, true));
        }
        return typedBlocks;
    }

    private boolean isProtectedBlock(Block block) {
        MacroMarkerBlock mmBlock;
        return block instanceof MacroMarkerBlock && "code".equals((mmBlock = (MacroMarkerBlock)block).getId());
    }
}

