/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.SpecialSymbolBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.reference.link.LinkLabelGenerator;

public class PlainTextBlockFilter
implements BlockFilter {
    private static final Set<Class<? extends Block>> VALID_PLAINTEXT_BLOCKS = new HashSet<Class<? extends Block>>();
    private Parser plainTextParser;
    private LinkLabelGenerator linkLabelGenerator;

    public PlainTextBlockFilter(Parser plainTextParser, LinkLabelGenerator linkLabelGenerator) {
        this.plainTextParser = plainTextParser;
        this.linkLabelGenerator = linkLabelGenerator;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public List<Block> filter(Block block) {
        void var2_5;
        if (VALID_PLAINTEXT_BLOCKS.contains(block.getClass())) {
            List<Block> list = Collections.singletonList(block);
            return var2_5;
        }
        if (block instanceof LinkBlock) {
            LinkBlock linkBlock = (LinkBlock)block;
            if (block.getChildren().isEmpty()) {
                ResourceReference reference = linkBlock.getReference();
                List<Block> list = this.filterLinkBlock(reference);
                return var2_5;
            }
        }
        List list = Collections.emptyList();
        return var2_5;
    }

    private List<Block> filterLinkBlock(ResourceReference reference) {
        List<Block> labelBlocks;
        ResourceType resourceType = reference.getType();
        String label = ResourceType.DOCUMENT.equals(resourceType) || ResourceType.SPACE.equals(resourceType) || ResourceType.PAGE.equals(resourceType) ? this.linkLabelGenerator.generate(reference) : reference.getReference();
        try {
            labelBlocks = this.plainTextParser.parse(new StringReader(label)).getChildren();
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Failed to parse link label [%s] as plain text for reference [%s]", label, reference), e);
        }
        return labelBlocks.isEmpty() ? labelBlocks : labelBlocks.get(0).getChildren();
    }

    static {
        VALID_PLAINTEXT_BLOCKS.add(WordBlock.class);
        VALID_PLAINTEXT_BLOCKS.add(SpaceBlock.class);
        VALID_PLAINTEXT_BLOCKS.add(SpecialSymbolBlock.class);
        VALID_PLAINTEXT_BLOCKS.add(NewLineBlock.class);
    }
}

