/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.zipexplorer;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.zipexplorer.ZipExplorerPluginAPI;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipExplorerPlugin
extends XWikiDefaultPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ZipExplorerPlugin.class);
    private static final String URL_SEPARATOR = "/";

    public ZipExplorerPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
        this.init(context);
    }

    public String getName() {
        return "zipexplorer";
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new ZipExplorerPluginAPI((ZipExplorerPlugin)plugin, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public XWikiAttachment downloadAttachment(XWikiAttachment attachment, XWikiContext context) {
        XWikiAttachment newAttachment;
        block12: {
            BufferedInputStream stream;
            String filename;
            block11: {
                if (attachment == null) {
                    return null;
                }
                String url = context.getRequest().getRequestURI();
                if (attachment.getReference().getDocumentReference().getSpaceReferences().size() > 1 || !this.isValidZipURL(url, context.getAction().trim())) {
                    return attachment;
                }
                filename = this.getFileLocationFromZipURL(url, context.getAction().trim());
                newAttachment = new XWikiAttachment();
                newAttachment.setDoc(attachment.getDoc(), false);
                newAttachment.setAuthorReference(attachment.getAuthorReference());
                newAttachment.setDate(attachment.getDate());
                stream = null;
                stream = new BufferedInputStream(attachment.getContentInputStream(context));
                if (this.isZipFile(stream)) break block11;
                XWikiAttachment xWikiAttachment = attachment;
                IOUtils.closeQuietly((InputStream)stream);
                return xWikiAttachment;
            }
            try {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(stream);
                while ((entry = zis.getNextEntry()) != null) {
                    String entryName = entry.getName();
                    if (!entryName.equals(filename)) continue;
                    newAttachment.setFilename(entryName);
                    if (entry.getSize() == -1L) {
                        byte[] data = IOUtils.toByteArray((InputStream)zis);
                        newAttachment.setContent(data);
                        break;
                    }
                    newAttachment.setContent((InputStream)zis, (int)entry.getSize());
                    break;
                }
            }
            catch (XWikiException e) {
                e.printStackTrace();
                IOUtils.closeQuietly((InputStream)stream);
                break block12;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(stream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)stream);
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        return newAttachment;
    }

    public List<String> getFileList(Document document, String attachmentName, XWikiContext context) {
        ArrayList<String> zipList = new ArrayList<String>();
        Attachment attachment = document.getAttachment(attachmentName);
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(attachment.getContent());
            if (this.isZipFile(stream)) {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(stream);
                while ((entry = zis.getNextEntry()) != null) {
                    zipList.add(entry.getName());
                }
            }
        }
        catch (XWikiException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zipList;
    }

    public List<ListItem> getFileTreeList(Document document, String attachmentName, XWikiContext context) {
        List<String> flatList = this.getFileList(document, attachmentName, context);
        HashMap<String, ListItem> fileTree = new HashMap<String, ListItem>();
        ArrayList<ListItem> res = new ArrayList<ListItem>();
        for (String url : flatList) {
            StringBuilder buf = new StringBuilder(url.length());
            String parentBuf = "";
            String[] aUrl = url.split(URL_SEPARATOR);
            for (int i = 0; i < aUrl.length; ++i) {
                if (i == aUrl.length - 1 && !url.endsWith(URL_SEPARATOR)) {
                    buf.append(aUrl[i]);
                } else {
                    buf.append(aUrl[i] + URL_SEPARATOR);
                }
                ListItem item = new ListItem(buf.toString(), aUrl[i], parentBuf);
                if (!fileTree.containsKey(buf.toString())) {
                    res.add(item);
                }
                fileTree.put(buf.toString(), item);
                parentBuf = buf.toString();
            }
        }
        return res;
    }

    public String getFileLink(Document document, String attachmentName, String fileName, XWikiContext context) {
        return document.getAttachmentURL(attachmentName) + URL_SEPARATOR + fileName;
    }

    protected String getFileLocationFromZipURL(String url, String action) {
        String path = url.substring(url.indexOf(URL_SEPARATOR + action));
        int pos = 0;
        for (int i = 0; pos > -1 && i < 4; ++i) {
            pos = path.indexOf(URL_SEPARATOR, pos + 1);
        }
        if (pos == -1) {
            return "";
        }
        path = path.substring(pos + 1);
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (IOException e) {
            LOG.error("Failed to decode URL path [" + path + "]", (Throwable)e);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isZipFile(InputStream filecontent) {
        int standardZipHeader = 1347093252;
        filecontent.mark(8);
        try {
            DataInputStream datastream = new DataInputStream(filecontent);
            int fileHeader = datastream.readInt();
            boolean bl = standardZipHeader == fileHeader;
            return bl;
        }
        catch (IOException datastream) {
        }
        finally {
            try {
                filecontent.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected boolean isValidZipURL(String url, String action) {
        boolean isValidZipURL = false;
        try {
            String filenameInZip = this.getFileLocationFromZipURL(url, action);
            if (filenameInZip.length() > 0) {
                isValidZipURL = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isValidZipURL;
    }
}

