/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar.internal.property;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.xar.internal.XarObjectPropertySerializer;

@Component
@Named(value="Date")
@Singleton
public class DateXarObjectPropertySerializer
implements XarObjectPropertySerializer {
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
    private static final Logger LOGGER = LoggerFactory.getLogger(DateXarObjectPropertySerializer.class);

    public static Date parseDate(String source) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_FORMAT);
        try {
            return format.parse(source);
        }
        catch (ParseException e) {
            SimpleDateFormat sdfOld = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US);
            LOGGER.warn("Failed to parse date [{}] using format [{}]. Trying again with format [{}].", new Object[]{source, DEFAULT_FORMAT, sdfOld.toPattern()});
            try {
                return sdfOld.parse(source);
            }
            catch (ParseException exception) {
                LOGGER.warn("Failed to parse date [{}] using format [{}]. Defaulting to the current date.", (Object)source, (Object)sdfOld.toPattern());
                return new Date();
            }
        }
    }

    public static String serializeDate(Object date) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_FORMAT);
        return date == null ? "" : format.format(date);
    }

    @Override
    public Object read(XMLStreamReader reader) throws XMLStreamException {
        String value = reader.getElementText();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return DateXarObjectPropertySerializer.parseDate(value);
    }

    @Override
    public void write(XMLStreamWriter writer, Object value) throws XMLStreamException {
        writer.writeCharacters(DateXarObjectPropertySerializer.serializeDate(value));
    }
}

