/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarEntryType;
import org.xwiki.xar.XarEntryTypeResolver;

@Component
@Singleton
public class DefaultXarEntryTypeResolver
implements XarEntryTypeResolver {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;
    @Inject
    private XarEntryType defaultType;
    @Inject
    private Logger logger;

    @Override
    public XarEntryType resolve(XarEntry entry, boolean fallbackOnDefault) {
        String reference;
        String referencehint;
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        if (entry != null && entry.getEntryType() != null && componentManager.hasComponent(XarEntryType.class, entry.getEntryType())) {
            try {
                return (XarEntryType)componentManager.getInstance(XarEntryType.class, entry.getEntryType());
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup XAR entry type for name [{}]", (Object)entry.getEntryType(), (Object)e);
            }
        }
        if (componentManager.hasComponent(XarEntryType.class, referencehint = "document:" + (reference = (String)this.referenceSerializer.serialize((EntityReference)entry, new Object[0])))) {
            try {
                return (XarEntryType)componentManager.getInstance(XarEntryType.class, referencehint);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup XAR entry type for reference [{}]", (Object)reference, (Object)e);
            }
        }
        return fallbackOnDefault ? this.defaultType : null;
    }

    @Override
    public XarEntryType getDefault() {
        return this.defaultType;
    }
}

