/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.store.TemporaryAttachmentSessionsManager;
import org.xwiki.wysiwyg.converter.HTMLConverter;
import org.xwiki.wysiwyg.importer.AttachmentImporter;

@Component
@Named(value="wysiwyg")
@Singleton
public class WysiwygEditorScriptService
implements ScriptService {
    private static final String IS_IN_RENDERING_ENGINE = "isInRenderingEngine";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private HTMLConverter htmlConverter;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="office")
    private AttachmentImporter officeAttachmentImporter;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private TemporaryAttachmentSessionsManager temporaryAttachmentSessionsManager;

    public boolean isSyntaxSupported(String syntaxId) {
        if (syntaxId.equals(Syntax.XHTML_1_0.toIdString())) {
            return false;
        }
        try {
            this.contextComponentManager.getInstance(Parser.class, syntaxId);
            this.contextComponentManager.getInstance(PrintRendererFactory.class, syntaxId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Syntax getHTMLSyntax() {
        return Syntax.ANNOTATED_HTML_5_0;
    }

    @Deprecated
    public String parseAndRender(String html, String syntaxId) {
        return this.parseAndRender(html, this.getSyntax(syntaxId), null);
    }

    public String parseAndRender(String html, Syntax syntax, EntityReference sourceReference) {
        return this.parseAndRender(html, syntax, sourceReference, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseAndRender(String html, Syntax syntax, EntityReference sourceReference, boolean restricted) {
        XWikiDocument securityDocument = this.createSecurityDocument();
        XWikiDocument originalSecurityDocument = this.setSecurityDocument(securityDocument);
        Object isInRenderingEngine = ((XWikiContext)this.xcontextProvider.get()).get((Object)IS_IN_RENDERING_ENGINE);
        try {
            ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, (Object)true);
            EntityReference resolvedSourceReference = sourceReference;
            if (resolvedSourceReference == null) {
                resolvedSourceReference = securityDocument.getDocumentReference();
            }
            String string = this.htmlConverter.parseAndRender(html, syntax, resolvedSourceReference, restricted);
            return string;
        }
        catch (Exception e) {
            String string = html;
            return string;
        }
        finally {
            if (isInRenderingEngine != null) {
                ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                ((XWikiContext)this.xcontextProvider.get()).remove((Object)IS_IN_RENDERING_ENGINE);
            }
            this.setSecurityDocument(originalSecurityDocument);
        }
    }

    public String render(DocumentReference templateReference) {
        if (!this.authorization.hasAccess(Right.VIEW, (EntityReference)templateReference)) {
            return null;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument template = xcontext.getWiki().getDocument(templateReference, xcontext);
            String templateSyntax = template.getSyntax().toIdString();
            String output = xcontext.getDoc().getRenderedContent(template.getContent(), templateSyntax, xcontext);
            return xcontext.getWiki().getPluginManager().endParsing(output, xcontext);
        }
        catch (XWikiException e) {
            this.logger.debug("Failed to render [{}].", (Object)templateReference, (Object)e);
            return null;
        }
    }

    @Deprecated
    public String toAnnotatedXHTML(String source, String syntaxId) {
        return this.toAnnotatedXHTML(source, this.getSyntax(syntaxId), null);
    }

    public String toAnnotatedXHTML(String source, Syntax syntax, EntityReference sourceReference) {
        return this.toAnnotatedXHTML(source, syntax, sourceReference, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toAnnotatedXHTML(String source, Syntax syntax, EntityReference sourceReference, boolean restricted) {
        XWikiDocument securityDocument = this.createSecurityDocument();
        XWikiDocument originalSecurityDocument = this.setSecurityDocument(securityDocument);
        Object isInRenderingEngine = ((XWikiContext)this.xcontextProvider.get()).get((Object)IS_IN_RENDERING_ENGINE);
        try {
            ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, (Object)true);
            EntityReference resolvedSourceReference = sourceReference;
            if (resolvedSourceReference == null) {
                resolvedSourceReference = securityDocument.getDocumentReference();
            }
            String string = this.htmlConverter.toHTML(source, syntax, resolvedSourceReference, restricted);
            return string;
        }
        catch (Exception e) {
            String string = source;
            return string;
        }
        finally {
            if (isInRenderingEngine != null) {
                ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                ((XWikiContext)this.xcontextProvider.get()).remove((Object)IS_IN_RENDERING_ENGINE);
            }
            this.setSecurityDocument(originalSecurityDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fromAnnotatedXHTML(String html, String targetSyntaxId) {
        XWikiDocument originalSecurityDocument = this.setSecurityDocument(this.createSecurityDocument());
        Object isInRenderingEngine = ((XWikiContext)this.xcontextProvider.get()).get((Object)IS_IN_RENDERING_ENGINE);
        try {
            ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, (Object)true);
            String string = this.htmlConverter.fromHTML(html, targetSyntaxId);
            return string;
        }
        catch (Exception e) {
            String string = html;
            return string;
        }
        finally {
            if (isInRenderingEngine != null) {
                ((XWikiContext)this.xcontextProvider.get()).put((Object)IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                ((XWikiContext)this.xcontextProvider.get()).remove((Object)IS_IN_RENDERING_ENGINE);
            }
            this.setSecurityDocument(originalSecurityDocument);
        }
    }

    private XWikiDocument createSecurityDocument() {
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument clonedDocument = xwikiContext.getDoc().clone();
        xwikiContext.getRequest().getEffectiveAuthor().ifPresent(arg_0 -> ((DocumentAuthors)clonedDocument.getAuthors()).setContentAuthor(arg_0));
        this.injectTemoraryAttachments(clonedDocument);
        return clonedDocument;
    }

    private void injectTemoraryAttachments(XWikiDocument clonedDocument) {
        Collection uploadedAttachments = this.temporaryAttachmentSessionsManager.getUploadedAttachments(clonedDocument.getDocumentReference());
        if (!uploadedAttachments.isEmpty()) {
            for (XWikiAttachment uploadedAttachment : uploadedAttachments) {
                clonedDocument.setAttachment(uploadedAttachment);
            }
        }
    }

    private XWikiDocument setSecurityDocument(XWikiDocument document) {
        return (XWikiDocument)((XWikiContext)this.xcontextProvider.get()).put((Object)"sdoc", (Object)document);
    }

    public String importOfficeAttachment(AttachmentReference attachmentReference, Map<String, Object> parameters) {
        try {
            return this.officeAttachmentImporter.toHTML(attachmentReference, parameters);
        }
        catch (Exception e) {
            this.logger.warn("Failed to import office attachment [{}]. Root cause is: {}", this.entityReferenceSerializer.serialize((EntityReference)attachmentReference, new Object[0]), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private Syntax getSyntax(String syntaxId) {
        try {
            return Syntax.valueOf((String)syntaxId);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Invalid syntax [%s]", syntaxId), e);
        }
    }
}

