/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.converter;

import jakarta.inject.Inject;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.url.URLSecurityManager;
import org.xwiki.wysiwyg.converter.JakartaRequestParameterConversionResult;
import org.xwiki.wysiwyg.converter.RequestParameterConverter;
import org.xwiki.wysiwyg.filter.MutableJakartaServletRequest;
import org.xwiki.wysiwyg.filter.MutableServletRequestFactory;

public abstract class AbstractRequestParameterConverter
implements RequestParameterConverter {
    private static final String CONVERSION_OUTPUT = "com.xpn.xwiki.wysiwyg.server.converter.output";
    private static final String CONVERSION_ERRORS = "com.xpn.xwiki.wysiwyg.server.converter.errors";
    @Inject
    protected Logger logger;
    @Inject
    private MutableServletRequestFactory mutableServletRequestFactory;
    @Inject
    private URLSecurityManager urlSecurityManager;

    @Override
    public Optional<ServletRequest> convert(ServletRequest request, ServletResponse response) throws IOException {
        Optional<ServletRequest> result;
        JakartaRequestParameterConversionResult conversionResult = this.convert(request);
        if (conversionResult.getErrors().isEmpty()) {
            result = Optional.of(conversionResult.getRequest());
        } else {
            result = Optional.empty();
            this.handleConversionErrors(conversionResult, response);
        }
        return result;
    }

    @Override
    public JakartaRequestParameterConversionResult convert(ServletRequest request) {
        MutableJakartaServletRequest mutableJakartaServletRequest;
        MutableJakartaServletRequest mutableServletRequest = request instanceof MutableJakartaServletRequest ? (mutableJakartaServletRequest = (MutableJakartaServletRequest)request) : this.mutableServletRequestFactory.newInstance(request);
        JakartaRequestParameterConversionResult result = new JakartaRequestParameterConversionResult(mutableServletRequest);
        String[] parametersRequiringConversion = request.getParameterValues(this.getConverterParameterName());
        if (parametersRequiringConversion != null) {
            result.getRequest().removeParameter(this.getConverterParameterName());
            this.convert(parametersRequiringConversion, result);
        }
        return result;
    }

    protected abstract String getConverterParameterName();

    protected abstract void convert(String[] var1, JakartaRequestParameterConversionResult var2);

    private void handleConversionErrors(JakartaRequestParameterConversionResult conversionResult, ServletResponse res) throws IOException {
        HttpServletRequest httpRequest;
        MutableJakartaServletRequest mutableRequest = conversionResult.getRequest();
        ServletRequest originalRequest = mutableRequest.getRequest();
        if (originalRequest instanceof HttpServletRequest && "XMLHttpRequest".equals((httpRequest = (HttpServletRequest)originalRequest).getHeader("X-Requested-With"))) {
            StringBuilder errorMessage = new StringBuilder();
            for (Map.Entry<String, Throwable> entry : conversionResult.getErrors().entrySet()) {
                errorMessage.append(entry.getKey()).append(": ");
                errorMessage.append(entry.getValue().getLocalizedMessage()).append('\n');
            }
            ((HttpServletResponse)res).sendError(400, errorMessage.substring(0, errorMessage.length() - 1));
            return;
        }
        String redirectURL = mutableRequest.getParameter("xerror");
        if (redirectURL == null) {
            redirectURL = mutableRequest.getReferer();
        }
        Object queryString = StringUtils.substringAfterLast((String)redirectURL, (String)String.valueOf('?'));
        redirectURL = StringUtils.substringBeforeLast((String)redirectURL, (String)String.valueOf('?'));
        if (!((String)(queryString = ((String)queryString).replaceAll("key=.*&?", ""))).isEmpty() && !((String)queryString).endsWith(String.valueOf('&'))) {
            queryString = (String)queryString + "&";
        }
        queryString = (String)queryString + "key=" + this.save(conversionResult);
        String unsafeURL = redirectURL + "?" + (String)queryString;
        if (originalRequest instanceof HttpServletRequest) {
            HttpServletRequest httpRequest2 = (HttpServletRequest)originalRequest;
            try {
                URI safeURI = this.urlSecurityManager.parseToSafeURI(unsafeURL, httpRequest2.getServerName());
                mutableRequest.sendRedirect(res, safeURI.toString());
            }
            catch (SecurityException | URISyntaxException e) {
                this.logger.warn("Possible phishing attack, attempting to redirect to [{}], this request has been blocked. If the request was legitimate, please check the URL security configuration. You might need to add the domain related to this request in the list of trusted domains in the configuration: it can be configured in xwiki.properties in url.trustedDomains.", (Object)unsafeURL);
                this.logger.debug("Original error preventing the redirect: ", (Throwable)e);
                ((HttpServletResponse)res).sendError(400, "The error redirect URI isn't considered safe.");
            }
        }
    }

    private String save(JakartaRequestParameterConversionResult conversionResult) {
        String key = RandomStringUtils.secure().nextAlphanumeric(4);
        MutableJakartaServletRequest request = conversionResult.getRequest();
        HashMap<String, Map<String, String>> conversionOutput = (HashMap<String, Map<String, String>>)request.getSessionAttribute(CONVERSION_OUTPUT);
        if (conversionOutput == null) {
            conversionOutput = new HashMap<String, Map<String, String>>();
            request.setSessionAttribute(CONVERSION_OUTPUT, conversionOutput);
        }
        conversionOutput.put(key, conversionResult.getOutput());
        HashMap<String, Map<String, Throwable>> conversionErrors = (HashMap<String, Map<String, Throwable>>)request.getSessionAttribute(CONVERSION_ERRORS);
        if (conversionErrors == null) {
            conversionErrors = new HashMap<String, Map<String, Throwable>>();
            request.setSessionAttribute(CONVERSION_ERRORS, conversionErrors);
        }
        conversionErrors.put(key, conversionResult.getErrors());
        return key;
    }
}

