/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.cleaner;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.wysiwyg.cleaner.HTMLCleaner;
import org.xwiki.wysiwyg.internal.cleaner.HTMLFilter;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Singleton
public class DefaultHTMLCleaner
implements HTMLCleaner {
    @Inject
    private org.xwiki.xml.html.HTMLCleaner cleaner;
    @Inject
    private List<HTMLFilter> specificFilters;

    @Override
    public String clean(String dirtyHTML) {
        this.specificFilters.sort(Comparator.comparingInt(HTMLFilter::getPriority));
        HTMLCleanerConfiguration config = this.cleaner.getDefaultConfiguration();
        ArrayList<HTMLFilter> filters = new ArrayList<HTMLFilter>();
        filters.addAll(this.specificFilters);
        filters.addAll(config.getFilters());
        config.setFilters(filters);
        HashMap<String, String> parameters = new HashMap<String, String>(config.getParameters());
        parameters.put("htmlVersion", "5");
        config.setParameters(parameters);
        Document document = this.cleaner.clean((Reader)new StringReader(dirtyHTML), config);
        return HTMLUtils.toString((Document)document);
    }
}

