/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.workspacesmigrator.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.workspacesmigrator.internal.DocumentRestorerFromAttachedXAR;
import org.xwiki.wiki.workspacesmigrator.internal.SearchSuggestCustomConfigDeleter;

@Component
@Named(value="R530000WorkspacesMigration")
@Singleton
public class WorkspacesMigration
extends AbstractHibernateDataMigration {
    private static final String WORKSPACE_CLASS_SPACE = "WorkspaceManager";
    private static final String WORKSPACE_CLASS_PAGE = "WorkspaceClass";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private DocumentRestorerFromAttachedXAR documentRestorerFromAttachedXAR;
    @Inject
    private SearchSuggestCustomConfigDeleter searchSuggestCustomConfigDeleter;
    @Inject
    private Logger logger;

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
        this.deleteSearchSuggestCustomConfig(currentWikiId);
        if (this.isWorkspace(currentWikiId)) {
            this.restoreDeletedDocuments(currentWikiId);
        }
    }

    private boolean isWorkspace(String wikiId) throws XWikiException {
        DocumentReference oldClassDocument;
        if (wikiId.equals(this.wikiDescriptorManager.getMainWikiId())) {
            return false;
        }
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        DocumentReference oldWikiDescriptorReference = new DocumentReference(this.wikiDescriptorManager.getMainWikiId(), "XWiki", String.format("XWikiServer%s", StringUtils.capitalize((String)wikiId)));
        XWikiDocument oldWikiDescriptor = xwiki.getDocument(oldWikiDescriptorReference, context);
        BaseObject oldObject = oldWikiDescriptor.getXObject(oldClassDocument = new DocumentReference(this.wikiDescriptorManager.getMainWikiId(), WORKSPACE_CLASS_SPACE, WORKSPACE_CLASS_PAGE));
        return oldObject != null || this.isWorkspaceTemplate(wikiId);
    }

    private boolean isWorkspaceTemplate(String wikiId) throws XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        return wikiId.equals("workspacetemplate") && xwiki.exists(new DocumentReference(wikiId, "XWiki", "ManageWorkspace"), context);
    }

    public String getDescription() {
        return "https://jira.xwiki.org/browse/XWIKI-9738";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(53000);
    }

    private void deleteSearchSuggestCustomConfig(String wikiId) throws XWikiException {
        this.searchSuggestCustomConfigDeleter.deleteSearchSuggestCustomConfig(wikiId);
    }

    private void restoreDeletedDocuments(String wikiId) {
        XWikiContext xcontext = this.getXWikiContext();
        XWiki xwiki = xcontext.getWiki();
        LinkedList<DocumentReference> documentsToRestore = new LinkedList<DocumentReference>();
        documentsToRestore.add(new DocumentReference(wikiId, "XWiki", "AdminRegistrationSheet"));
        documentsToRestore.add(new DocumentReference(wikiId, "XWiki", "RegistrationConfig"));
        documentsToRestore.add(new DocumentReference(wikiId, "XWiki", "RegistrationHelp"));
        documentsToRestore.add(new DocumentReference(wikiId, "XWiki", "AdminUsersSheet"));
        Iterator itDocumentsToRestore = documentsToRestore.iterator();
        while (itDocumentsToRestore.hasNext()) {
            DocumentReference docRef = (DocumentReference)itDocumentsToRestore.next();
            try {
                if (!xwiki.exists(docRef, xcontext)) continue;
                itDocumentsToRestore.remove();
            }
            catch (XWikiException e) {
                this.logger.error("Failed to test the existence of document with reference [{}]", (Object)docRef, (Object)e);
            }
        }
        if (documentsToRestore.isEmpty()) {
            return;
        }
        this.restoreDocumentsFromWorkspaceXar(documentsToRestore);
        if (documentsToRestore.isEmpty()) {
            return;
        }
        this.restoreDocumentFromMainWiki(documentsToRestore);
        if (!documentsToRestore.isEmpty()) {
            Object documentsToRestoreAsString = new String();
            int counter = 0;
            for (DocumentReference d : documentsToRestore) {
                if (counter++ > 0) {
                    documentsToRestoreAsString = (String)documentsToRestoreAsString + ", ";
                }
                documentsToRestoreAsString = (String)documentsToRestoreAsString + String.valueOf(d);
            }
            this.logger.warn("Failed to restore some documents: [{}]. You should import manually (1) xwiki-platform-administration-ui.xar and then (2) xwiki-platform-wiki-ui-wiki.xar into your wiki, to restore these documents.", documentsToRestoreAsString);
        }
    }

    private void restoreDocumentsFromWorkspaceXar(List<DocumentReference> documentsToRestore) {
        DocumentReference installDocumentReference = new DocumentReference(this.wikiDescriptorManager.getMainWikiId(), WORKSPACE_CLASS_SPACE, "Install");
        try {
            this.documentRestorerFromAttachedXAR.restoreDocumentFromAttachedXAR(installDocumentReference, "workspace-template.xar", documentsToRestore);
        }
        catch (XWikiException e) {
            this.logger.error("Error while restoring documents from the Workspace XAR", (Throwable)e);
        }
    }

    private void restoreDocumentFromMainWiki(List<DocumentReference> documentsToRestore) {
        XWikiContext xcontext = this.getXWikiContext();
        XWiki xwiki = xcontext.getWiki();
        WikiReference mainWikiReference = new WikiReference(this.wikiDescriptorManager.getMainWikiId());
        Iterator<DocumentReference> itDocumentsToRestore = documentsToRestore.iterator();
        while (itDocumentsToRestore.hasNext()) {
            DocumentReference docRef = itDocumentsToRestore.next();
            DocumentReference mainDocRef = docRef.setWikiReference(mainWikiReference);
            try {
                if (!xwiki.exists(mainDocRef, xcontext)) continue;
                xwiki.copyDocument(mainDocRef, docRef, xcontext);
                itDocumentsToRestore.remove();
            }
            catch (XWikiException e) {
                this.logger.error("Failed to copy [{}] to [{}].", new Object[]{mainDocRef, docRef, e});
            }
        }
    }
}

