/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.workspacesmigrator.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.wiki.workspacesmigrator.internal.DocumentRestorerFromAttachedXAR;

@Component
@Singleton
public class DefaultDocumentRestorerFromAttachedXAR
implements DocumentRestorerFromAttachedXAR {
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Environment environment;

    private File getTemporaryZipFile(DocumentReference docReference, String attachmentName) throws XWikiException, IOException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        XWikiDocument document = xwiki.getDocument(docReference, xcontext);
        if (document.isNew()) {
            this.logger.warn("[{}] does not exist", (Object)docReference);
            return null;
        }
        XWikiAttachment xar = document.getAttachment(attachmentName);
        if (xar == null) {
            this.logger.warn("[{}] has no attachment named [{}].", (Object)docReference, (Object)attachmentName);
            return null;
        }
        File tempFile = File.createTempFile(attachmentName, ".tmp", this.environment.getTemporaryDirectory());
        FileUtils.copyInputStreamToFile((InputStream)xar.getContentInputStream(xcontext), (File)tempFile);
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreDocumentFromAttachedXAR(DocumentReference docReference, String attachmentName, List<DocumentReference> documentsToRestore) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        File tempZipFile = null;
        try {
            tempZipFile = this.getTemporaryZipFile(docReference, attachmentName);
            if (tempZipFile == null) {
                return;
            }
            ZipFile zipFile = new ZipFile(tempZipFile);
            Iterator<DocumentReference> itDocumentsToRestore = documentsToRestore.iterator();
            while (itDocumentsToRestore.hasNext()) {
                DocumentReference docRef = itDocumentsToRestore.next();
                String fileNameToRestore = String.format("%s/%s.xml", docRef.getLastSpaceReference().getName(), docRef.getName());
                ZipArchiveEntry zipEntry = zipFile.getEntry(fileNameToRestore);
                if (zipEntry == null) continue;
                XWikiDocument docToRestore = xwiki.getDocument(docRef, xcontext);
                docToRestore.fromXML(zipFile.getInputStream(zipEntry));
                xwiki.saveDocument(docToRestore, xcontext);
                itDocumentsToRestore.remove();
            }
            zipFile.close();
        }
        catch (IOException e) {
            this.logger.error("Error during the decompression of [{}].", (Object)attachmentName, (Object)e);
        }
        finally {
            if (tempZipFile != null) {
                tempZipFile.delete();
            }
        }
    }
}

