/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.user.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.Strings;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.wiki.user.MemberCandidacy;
import org.xwiki.wiki.user.MembershipType;
import org.xwiki.wiki.user.UserScope;
import org.xwiki.wiki.user.WikiUserConfiguration;
import org.xwiki.wiki.user.WikiUserManager;
import org.xwiki.wiki.user.WikiUserManagerException;
import org.xwiki.wiki.user.internal.WikiCandidateMemberClassInitializer;
import org.xwiki.wiki.user.internal.WikiUserConfigurationHelper;

@Component
@Singleton
public class DefaultWikiUserManager
implements WikiUserManager {
    private static final LocalDocumentReference GROUPCLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiGroups");
    private static final String GROUP_CLASS_MEMBER_FIELD = "member";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private WikiUserConfigurationHelper wikiUserConfigurationHelper;
    @Inject
    private EntityReferenceSerializer<String> documentReferenceSerializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public UserScope getUserScope(String wikiId) throws WikiUserManagerException {
        return this.wikiUserConfigurationHelper.getConfiguration(wikiId).getUserScope();
    }

    public void setUserScope(String wikiId, UserScope scope) throws WikiUserManagerException {
        WikiUserConfiguration configuration = this.wikiUserConfigurationHelper.getConfiguration(wikiId);
        configuration.setUserScope(scope);
        this.wikiUserConfigurationHelper.saveConfiguration(configuration, wikiId);
    }

    public MembershipType getMembershipType(String wikiId) throws WikiUserManagerException {
        return this.wikiUserConfigurationHelper.getConfiguration(wikiId).getMembershipType();
    }

    public void setMembershipType(String wikiId, MembershipType type) throws WikiUserManagerException {
        WikiUserConfiguration configuration = this.wikiUserConfigurationHelper.getConfiguration(wikiId);
        configuration.setMembershipType(type);
        this.wikiUserConfigurationHelper.saveConfiguration(configuration, wikiId);
    }

    public Collection<String> getLocalUsers(String wikiId) throws WikiUserManagerException {
        return null;
    }

    private XWikiDocument getMembersGroupDocument(String wikiId) throws WikiUserManagerException {
        DocumentReference memberGroupReference = new DocumentReference(wikiId, "XWiki", "XWikiAllGroup");
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWiki xwiki = xcontext.getWiki();
            return xwiki.getDocument(memberGroupReference, xcontext);
        }
        catch (XWikiException e) {
            throw new WikiUserManagerException(String.format("Fail to load the member group document [%s].", memberGroupReference.toString()), (Throwable)e);
        }
    }

    private void saveGroupDocument(XWikiDocument document, String message) throws WikiUserManagerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        document.setHidden(Boolean.valueOf(true));
        if (document.getCreatorReference() == null) {
            document.setCreatorReference(xcontext.getUserReference());
        }
        if (document.getAuthorReference() == null) {
            document.setAuthorReference(xcontext.getUserReference());
        }
        try {
            xwiki.saveDocument(document, message, xcontext);
        }
        catch (XWikiException e) {
            throw new WikiUserManagerException("Fail to save the member group", (Throwable)e);
        }
    }

    public Collection<String> getMembers(String wikiId) throws WikiUserManagerException {
        ArrayList<String> members = new ArrayList<String>();
        try {
            WikiDescriptor descriptor = this.wikiDescriptorManager.getById(wikiId);
            members.add(descriptor.getOwnerId());
        }
        catch (WikiManagerException e) {
            throw new WikiUserManagerException(String.format("Failed to get the descriptor for [%s]", wikiId), (Throwable)e);
        }
        XWikiDocument groupDoc = this.getMembersGroupDocument(wikiId);
        List memberObjects = groupDoc.getXObjects((EntityReference)GROUPCLASS_REFERENCE);
        if (memberObjects != null) {
            for (BaseObject object : memberObjects) {
                String member;
                if (object == null || (member = object.getStringValue(GROUP_CLASS_MEMBER_FIELD)).isEmpty() || members.contains(member)) continue;
                members.add(member);
            }
        }
        return members;
    }

    public boolean isMember(String userId, String wikiId) throws WikiUserManagerException {
        return this.getMembers(wikiId).contains(userId);
    }

    private void addMemberObject(XWikiDocument groupDoc, String userId) throws WikiUserManagerException {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            int objectNumber = groupDoc.createXObject((EntityReference)GROUPCLASS_REFERENCE, xcontext);
            BaseObject object = groupDoc.getXObject((EntityReference)GROUPCLASS_REFERENCE, objectNumber);
            object.set(GROUP_CLASS_MEMBER_FIELD, (Object)userId, xcontext);
        }
        catch (XWikiException e) {
            throw new WikiUserManagerException("Fail to add a member to the group", (Throwable)e);
        }
    }

    public void addMember(String userId, String wikiId) throws WikiUserManagerException {
        Collection<String> members = this.getMembers(wikiId);
        if (members.contains(userId)) {
            return;
        }
        XWikiDocument groupDoc = this.getMembersGroupDocument(wikiId);
        List memberObjects = (groupDoc = groupDoc.clone()).getXObjects((EntityReference)GROUPCLASS_REFERENCE);
        if (memberObjects == null || memberObjects.isEmpty()) {
            this.addMemberObject(groupDoc, "");
        }
        this.addMemberObject(groupDoc, userId);
        this.saveGroupDocument(groupDoc, String.format("Add [%s] to the group.", userId));
    }

    public void addMembers(Collection<String> userIds, String wikiId) throws WikiUserManagerException {
        Collection<String> members = this.getMembers(wikiId);
        XWikiDocument groupDoc = this.getMembersGroupDocument(wikiId);
        List memberObjects = (groupDoc = groupDoc.clone()).getXObjects((EntityReference)GROUPCLASS_REFERENCE);
        if (memberObjects == null || memberObjects.isEmpty()) {
            this.addMemberObject(groupDoc, "");
        }
        for (String userId : userIds) {
            if (members.contains(userId)) continue;
            this.addMemberObject(groupDoc, userId);
        }
        this.saveGroupDocument(groupDoc, "Add members to the group.");
    }

    public void removeMember(String userId, String wikiId) throws WikiUserManagerException {
        XWikiDocument groupDoc = this.getMembersGroupDocument(wikiId);
        List objects = (groupDoc = groupDoc.clone()).getXObjects((EntityReference)GROUPCLASS_REFERENCE);
        if (objects != null) {
            ArrayList<BaseObject> objectsToRemove = new ArrayList<BaseObject>();
            for (BaseObject object : objects) {
                String member;
                if (object == null || !userId.equals(member = object.getStringValue(GROUP_CLASS_MEMBER_FIELD))) continue;
                objectsToRemove.add(object);
            }
            for (BaseObject object : objectsToRemove) {
                groupDoc.removeXObject(object);
            }
            this.saveGroupDocument(groupDoc, String.format("Remove [%s] from the group.", userId));
        }
    }

    public void removeMembers(Collection<String> userIds, String wikiId) throws WikiUserManagerException {
        XWikiDocument groupDoc = this.getMembersGroupDocument(wikiId);
        List objects = (groupDoc = groupDoc.clone()).getXObjects((EntityReference)GROUPCLASS_REFERENCE);
        if (objects != null) {
            ArrayList<BaseObject> objectsToRemove = new ArrayList<BaseObject>();
            for (String userId : userIds) {
                for (BaseObject object : objects) {
                    String member;
                    if (object == null || !userId.equals(member = object.getStringValue(GROUP_CLASS_MEMBER_FIELD))) continue;
                    objectsToRemove.add(object);
                }
            }
            for (BaseObject object : objectsToRemove) {
                groupDoc.removeXObject(object);
            }
            this.saveGroupDocument(groupDoc, "Remove some users from the group.");
        }
    }

    private MemberCandidacy readCandidacyFromObject(BaseObject object, String wikiId) {
        MemberCandidacy candidacy = new MemberCandidacy();
        candidacy.setId(object.getNumber());
        candidacy.setWikiId(wikiId);
        candidacy.setUserId(object.getStringValue("userName"));
        candidacy.setUserComment(object.getLargeStringValue("userComment"));
        candidacy.setAdminId(object.getStringValue("reviewer"));
        candidacy.setAdminComment(object.getLargeStringValue("reviewerComment"));
        candidacy.setAdminPrivateComment(object.getLargeStringValue("reviewerPrivateComment"));
        candidacy.setStatus(MemberCandidacy.Status.valueOf((String)object.getStringValue("status").toUpperCase()));
        candidacy.setType(MemberCandidacy.CandidateType.valueOf((String)object.getStringValue("type").toUpperCase()));
        candidacy.setDateOfCreation(object.getDateValue("date"));
        candidacy.setDateOfCreation(object.getDateValue("resolutionDate"));
        return candidacy;
    }

    private Collection<MemberCandidacy> getAllMemberCandidacies(String wikiId, MemberCandidacy.CandidateType type) throws WikiUserManagerException {
        XWikiDocument groupDoc = this.getMembersGroupDocument(wikiId);
        ArrayList<MemberCandidacy> candidacies = new ArrayList<MemberCandidacy>();
        String typeString = type.name().toLowerCase();
        List candidacyObjects = groupDoc.getXObjects((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE);
        if (candidacyObjects != null) {
            for (BaseObject object : candidacyObjects) {
                if (object == null || !object.getStringValue("type").equals(typeString)) continue;
                candidacies.add(this.readCandidacyFromObject(object, wikiId));
            }
        }
        return candidacies;
    }

    public Collection<MemberCandidacy> getAllInvitations(String wikiId) throws WikiUserManagerException {
        return this.getAllMemberCandidacies(wikiId, MemberCandidacy.CandidateType.INVITATION);
    }

    public Collection<MemberCandidacy> getAllRequests(String wikiId) throws WikiUserManagerException {
        return this.getAllMemberCandidacies(wikiId, MemberCandidacy.CandidateType.REQUEST);
    }

    public boolean hasPendingInvitation(DocumentReference user, String wikiId) throws WikiUserManagerException {
        Collection<MemberCandidacy> invitations = this.getAllInvitations(wikiId);
        if (invitations != null) {
            String userId = (String)this.documentReferenceSerializer.serialize((EntityReference)user, new Object[0]);
            for (MemberCandidacy invitation : invitations) {
                if (!Strings.CS.equals(invitation.getUserId(), userId) || invitation.getStatus() != MemberCandidacy.Status.PENDING) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPendingRequest(DocumentReference user, String wikiId) throws WikiUserManagerException {
        Collection<MemberCandidacy> requests = this.getAllRequests(wikiId);
        if (requests != null) {
            String userId = (String)this.documentReferenceSerializer.serialize((EntityReference)user, new Object[0]);
            for (MemberCandidacy request : requests) {
                if (!Strings.CS.equals(request.getUserId(), userId) || request.getStatus() != MemberCandidacy.Status.PENDING) continue;
                return true;
            }
        }
        return false;
    }

    public MemberCandidacy getCandidacy(String wikiId, int candidacyId) throws WikiUserManagerException {
        XWikiDocument groupDoc = this.getMembersGroupDocument(wikiId);
        BaseObject object = groupDoc.getXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, candidacyId);
        return this.readCandidacyFromObject(object, wikiId);
    }

    public MemberCandidacy askToJoin(String userId, String wikiId, String message) throws WikiUserManagerException {
        MemberCandidacy candidacy = new MemberCandidacy(wikiId, userId, MemberCandidacy.CandidateType.REQUEST);
        candidacy.setUserComment(message);
        XWikiDocument groupDoc = this.getMembersGroupDocument(wikiId);
        groupDoc = groupDoc.clone();
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            int objectNumber = groupDoc.createXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, xcontext);
            candidacy.setId(objectNumber);
            BaseObject object = groupDoc.getXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, objectNumber);
            object.setStringValue("userName", candidacy.getUserId());
            object.setLargeStringValue("userComment", candidacy.getUserComment());
            object.setStringValue("status", candidacy.getStatus().name().toLowerCase());
            object.setDateValue("date", candidacy.getDateOfCreation());
            object.setStringValue("type", candidacy.getType().name().toLowerCase());
        }
        catch (XWikiException e) {
            throw new WikiUserManagerException("Failed to create a new join request.", (Throwable)e);
        }
        this.saveGroupDocument(groupDoc, String.format("[%s] asks to join the wiki.", userId));
        return candidacy;
    }

    public void join(String userId, String wikiId) throws WikiUserManagerException {
        if (!this.wikiUserConfigurationHelper.getConfiguration(wikiId).getMembershipType().equals((Object)MembershipType.OPEN)) {
            throw new WikiUserManagerException(String.format("The user [%s] is not authorized to join the wiki [%s].", userId, wikiId));
        }
        this.addMember(userId, wikiId);
    }

    public void leave(String userId, String wikiId) throws WikiUserManagerException {
        this.removeMember(userId, wikiId);
    }

    public void acceptRequest(MemberCandidacy request, String message, String privateComment) throws WikiUserManagerException {
        this.addMember(request.getUserId(), request.getWikiId());
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        request.setAdminId((String)this.documentReferenceSerializer.serialize((EntityReference)xcontext.getUserReference(), new Object[0]));
        request.setAdminComment(message);
        request.setAdminPrivateComment(privateComment);
        request.setStatus(MemberCandidacy.Status.ACCEPTED);
        request.setDateOfClosure(new Date());
        XWikiDocument groupDoc = this.getMembersGroupDocument(request.getWikiId());
        groupDoc = groupDoc.clone();
        BaseObject object = groupDoc.getXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, request.getId());
        object.setStringValue("reviewer", request.getAdminId());
        object.setLargeStringValue("reviewerComment", request.getAdminComment());
        object.setLargeStringValue("reviewerPrivateComment", request.getAdminPrivateComment());
        object.setDateValue("resolutionDate", request.getDateOfClosure());
        object.setStringValue("status", request.getStatus().name().toLowerCase());
        this.saveGroupDocument(groupDoc, String.format("Accept join request from user [%s]", request.getUserId()));
    }

    public void refuseRequest(MemberCandidacy request, String message, String privateComment) throws WikiUserManagerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        request.setAdminId((String)this.documentReferenceSerializer.serialize((EntityReference)xcontext.getUserReference(), new Object[0]));
        request.setAdminComment(message);
        request.setAdminPrivateComment(privateComment);
        request.setStatus(MemberCandidacy.Status.REJECTED);
        request.setDateOfClosure(new Date());
        XWikiDocument groupDoc = this.getMembersGroupDocument(request.getWikiId());
        groupDoc = groupDoc.clone();
        BaseObject object = groupDoc.getXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, request.getId());
        object.setStringValue("reviewer", request.getAdminId());
        object.setLargeStringValue("reviewerComment", request.getAdminComment());
        object.setLargeStringValue("reviewerPrivateComment", request.getAdminPrivateComment());
        object.setDateValue("resolutionDate", request.getDateOfClosure());
        object.setStringValue("status", request.getStatus().name().toLowerCase());
        this.saveGroupDocument(groupDoc, String.format("Reject join request from user [%s]", request.getUserId()));
    }

    public void cancelCandidacy(MemberCandidacy candidacy) throws WikiUserManagerException {
        XWikiDocument groupDoc = this.getMembersGroupDocument(candidacy.getWikiId());
        BaseObject object = (groupDoc = groupDoc.clone()).getXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, candidacy.getId());
        if (object != null) {
            groupDoc.removeXObject(object);
            this.saveGroupDocument(groupDoc, String.format("Candidacy [%d] is canceled.", candidacy.getId()));
        }
    }

    public MemberCandidacy invite(String userId, String wikiId, String message) throws WikiUserManagerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        MemberCandidacy candidacy = new MemberCandidacy(wikiId, userId, MemberCandidacy.CandidateType.INVITATION);
        candidacy.setUserComment(message);
        candidacy.setAdminId((String)this.documentReferenceSerializer.serialize((EntityReference)xcontext.getUserReference(), new Object[0]));
        XWikiDocument groupDoc = this.getMembersGroupDocument(wikiId);
        groupDoc = groupDoc.clone();
        try {
            int objectNumber = groupDoc.createXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, xcontext);
            candidacy.setId(objectNumber);
            BaseObject object = groupDoc.getXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, objectNumber);
            object.setStringValue("userName", candidacy.getUserId());
            object.setStringValue("reviewer", candidacy.getAdminId());
            object.setLargeStringValue("reviewerComment", message);
            object.setStringValue("status", candidacy.getStatus().name().toLowerCase());
            object.setDateValue("date", candidacy.getDateOfCreation());
            object.setStringValue("type", candidacy.getType().name().toLowerCase());
        }
        catch (XWikiException e) {
            throw new WikiUserManagerException("Failed to create a new invitation object.", (Throwable)e);
        }
        this.saveGroupDocument(groupDoc, String.format("[%s] is invited to join the wiki.", userId));
        return candidacy;
    }

    public void acceptInvitation(MemberCandidacy invitation, String message) throws WikiUserManagerException {
        this.addMember(invitation.getUserId(), invitation.getWikiId());
        invitation.setUserComment(message);
        invitation.setStatus(MemberCandidacy.Status.ACCEPTED);
        invitation.setDateOfClosure(new Date());
        XWikiDocument groupDoc = this.getMembersGroupDocument(invitation.getWikiId());
        groupDoc = groupDoc.clone();
        BaseObject object = groupDoc.getXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, invitation.getId());
        object.setLargeStringValue("userComment", invitation.getUserComment());
        object.setDateValue("resolutionDate", invitation.getDateOfClosure());
        object.setStringValue("status", invitation.getStatus().name().toLowerCase());
        this.saveGroupDocument(groupDoc, String.format("User [%s] has accepted to join the wiki. ", invitation.getUserId()));
    }

    public void refuseInvitation(MemberCandidacy invitation, String message) throws WikiUserManagerException {
        invitation.setUserComment(message);
        invitation.setStatus(MemberCandidacy.Status.REJECTED);
        invitation.setDateOfClosure(new Date());
        XWikiDocument groupDoc = this.getMembersGroupDocument(invitation.getWikiId());
        groupDoc = groupDoc.clone();
        BaseObject object = groupDoc.getXObject((EntityReference)WikiCandidateMemberClassInitializer.REFERENCE, invitation.getId());
        object.setLargeStringValue("userComment", invitation.getUserComment());
        object.setDateValue("resolutionDate", invitation.getDateOfClosure());
        object.setStringValue("status", invitation.getStatus().name().toLowerCase());
        this.saveGroupDocument(groupDoc, String.format("User [%s] has rejected the invitation to join the wiki.", invitation.getUserId()));
    }
}

