/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.template.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManager;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.wiki.properties.WikiPropertyGroup;
import org.xwiki.wiki.properties.WikiPropertyGroupException;
import org.xwiki.wiki.properties.WikiPropertyGroupProvider;
import org.xwiki.wiki.provisioning.WikiProvisioningJob;
import org.xwiki.wiki.provisioning.WikiProvisioningJobException;
import org.xwiki.wiki.provisioning.WikiProvisioningJobExecutor;
import org.xwiki.wiki.template.WikiTemplateManager;
import org.xwiki.wiki.template.WikiTemplateManagerException;
import org.xwiki.wiki.template.WikiTemplatePropertyGroup;

@Component
@Singleton
public class DefaultWikiTemplateManager
implements WikiTemplateManager {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="default")
    private WikiManager wikiManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private QueryManager queryManager;
    @Inject
    private WikiProvisioningJobExecutor wikiProvisionerExecutor;
    @Inject
    @Named(value="template")
    private WikiPropertyGroupProvider templateWikiPropertyGroupProvider;
    private String errorMessageNoDescriptor = "Failed to get the descriptor for [%s].";

    public Collection<WikiDescriptor> getTemplates() throws WikiTemplateManagerException {
        ArrayList<WikiDescriptor> result = new ArrayList<WikiDescriptor>();
        try {
            Query query = this.queryManager.createQuery("from doc.object(WikiManager.WikiTemplateClass) as descriptor where doc.name like 'XWikiServer%' and descriptor.iswikitemplate = 1", "xwql");
            query.setWiki(((XWikiContext)this.xcontextProvider.get()).getMainXWiki());
            List documentNames = query.execute();
            if (documentNames != null && !documentNames.isEmpty()) {
                for (String documentName : documentNames) {
                    String id = documentName.substring("XWiki.XWikiServer".length()).toLowerCase();
                    result.add(this.wikiDescriptorManager.getById(id));
                }
            }
        }
        catch (Exception e) {
            throw new WikiTemplateManagerException("Failed to locate XWiki.XWikiServerClass documents", (Throwable)e);
        }
        return result;
    }

    public void setTemplate(String wikiId, boolean value) throws WikiTemplateManagerException {
        try {
            WikiDescriptor descriptor = this.wikiDescriptorManager.getById(wikiId);
            WikiTemplatePropertyGroup group = (WikiTemplatePropertyGroup)descriptor.getPropertyGroup("template");
            if (group != null) {
                group.setTemplate(value);
                this.templateWikiPropertyGroupProvider.save((WikiPropertyGroup)group, wikiId);
            }
        }
        catch (WikiPropertyGroupException e) {
            throw new WikiTemplateManagerException(String.format("Failed to save the property group [%s]", "template"), (Throwable)e);
        }
        catch (WikiManagerException e) {
            throw new WikiTemplateManagerException(String.format(this.errorMessageNoDescriptor, wikiId), (Throwable)e);
        }
    }

    public boolean isTemplate(String wikiId) throws WikiTemplateManagerException {
        try {
            WikiDescriptor descriptor = this.wikiDescriptorManager.getById(wikiId);
            WikiTemplatePropertyGroup group = (WikiTemplatePropertyGroup)descriptor.getPropertyGroup("template");
            return group.isTemplate();
        }
        catch (WikiManagerException e) {
            throw new WikiTemplateManagerException(String.format(this.errorMessageNoDescriptor, wikiId), (Throwable)e);
        }
    }

    @Deprecated
    public WikiProvisioningJob createWikiFromTemplate(String newWikiId, String newWikiAlias, String templateId, String ownerId, boolean failOnExist) throws WikiTemplateManagerException {
        try {
            this.wikiManager.create(newWikiId, newWikiAlias, ownerId, failOnExist);
            return this.applyTemplate(newWikiId, templateId);
        }
        catch (WikiManagerException e) {
            throw new WikiTemplateManagerException(e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public WikiProvisioningJob applyTemplate(String wikiId, String templateId) throws WikiTemplateManagerException {
        try {
            return this.wikiProvisionerExecutor.createAndExecuteJob(wikiId, "wikiprovisioning.template", (Object)templateId);
        }
        catch (WikiProvisioningJobException e) {
            throw new WikiTemplateManagerException(e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public WikiProvisioningJob getWikiProvisioningJob(List<String> jobId) throws WikiTemplateManagerException {
        try {
            return this.wikiProvisionerExecutor.getJob(jobId);
        }
        catch (WikiProvisioningJobException e) {
            throw new WikiTemplateManagerException(e.getMessage(), (Throwable)e);
        }
    }
}

