/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.manager;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.wiki.internal.descriptor.DefaultWikiDescriptor;

@Component(roles={WikiDescriptorCache.class})
@Singleton
public class WikiDescriptorCache
implements Initializable {
    @Inject
    private CacheManager cacheManager;
    private Cache<DefaultWikiDescriptor> wikiAliasCache;
    private Cache<DefaultWikiDescriptor> wikiIdCache;
    private Collection<String> wikiIds;

    public void initialize() throws InitializationException {
        this.wikiAliasCache = this.createCache("wiki.descriptor.cache.wikiAlias");
        this.wikiIdCache = this.createCache("wiki.descriptor.cache.wikiId");
    }

    private Cache<DefaultWikiDescriptor> createCache(String cacheId) throws InitializationException {
        CacheConfiguration configuration = new CacheConfiguration(cacheId);
        try {
            return this.cacheManager.createNewCache(configuration);
        }
        catch (CacheException e) {
            throw new InitializationException(String.format("Failed to initialize wiki descriptor caches [%s]", configuration.getConfigurationId()), (Throwable)e);
        }
    }

    public void add(DefaultWikiDescriptor descriptor) {
        this.addFromId(descriptor.getId(), descriptor);
        for (String alias : descriptor.getAliases()) {
            if (alias == null) continue;
            this.addFromAlias(alias, descriptor);
        }
    }

    public void addFromAlias(String wikiAlias, DefaultWikiDescriptor descriptor) {
        this.wikiAliasCache.set(wikiAlias, (Object)descriptor);
    }

    public void addFromId(String wikiId, DefaultWikiDescriptor descriptor) {
        this.wikiIdCache.set(wikiId, (Object)descriptor);
    }

    public void remove(String wikiId, List<String> aliases) {
        this.wikiIdCache.remove(wikiId);
        for (String alias : aliases) {
            this.wikiAliasCache.remove(alias);
        }
    }

    public DefaultWikiDescriptor getFromId(String wikiId) {
        return (DefaultWikiDescriptor)((Object)this.wikiIdCache.get(wikiId));
    }

    public DefaultWikiDescriptor getFromAlias(String wikiAlias) {
        return (DefaultWikiDescriptor)((Object)this.wikiAliasCache.get(wikiAlias));
    }

    public void setWikiIds(Collection<String> wikiIds) {
        this.wikiIds = wikiIds;
    }

    public Collection<String> getWikiIds() {
        return this.wikiIds;
    }
}

