/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.manager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.wiki.configuration.WikiConfiguration;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.internal.descriptor.DefaultWikiDescriptor;
import org.xwiki.wiki.internal.descriptor.builder.WikiDescriptorBuilder;
import org.xwiki.wiki.internal.descriptor.builder.WikiDescriptorBuilderException;
import org.xwiki.wiki.internal.manager.WikiCreator;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultWikiCreator
implements WikiCreator {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private WikiDescriptorBuilder wikiDescriptorBuilder;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private WikiConfiguration wikiConfiguration;

    @Override
    public WikiDescriptor create(String wikiId, String wikiAlias) throws WikiManagerException {
        return this.create(wikiId, wikiAlias, null);
    }

    @Override
    public WikiDescriptor create(String wikiId, String wikiAlias, String ownerId) throws WikiManagerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        if (this.wikiConfiguration.shouldCreateDatabase()) {
            try {
                xwiki.getStore().createWiki(wikiId, context);
            }
            catch (Exception e) {
                throw new WikiManagerException(this.localizationManager.getTranslationPlain("wiki.databasecreation", new Object[]{wikiId}), (Throwable)e);
            }
        }
        WikiDescriptor descriptor = this.createDescriptor(wikiId, wikiAlias, ownerId);
        try {
            xwiki.initializeWiki(wikiId, true, context);
        }
        catch (Exception e) {
            throw new WikiManagerException(this.localizationManager.getTranslationPlain("wiki.databaseupdate", new Object[]{wikiId}), (Throwable)e);
        }
        return descriptor;
    }

    private WikiDescriptor createDescriptor(String wikiId, String wikiAlias, String ownerId) throws WikiManagerException {
        DefaultWikiDescriptor descriptor = new DefaultWikiDescriptor(wikiId, wikiAlias, ownerId);
        try {
            this.wikiDescriptorBuilder.save(descriptor);
            descriptor = this.wikiDescriptorManager.getById(wikiId);
        }
        catch (WikiDescriptorBuilderException e) {
            throw new WikiManagerException("Failed to build the descriptor document.", (Throwable)e);
        }
        return descriptor;
    }
}

