/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.internal;

import jakarta.servlet.http.Cookie;
import jakarta.websocket.HandshakeResponse;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.container.servlet.HttpServletResponseStub;

public class XWikiWebSocketResponseStub
extends HttpServletResponseStub {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiWebSocketResponseStub.class);
    private final HandshakeResponse response;

    public XWikiWebSocketResponseStub(HandshakeResponse response) {
        this.response = response;
    }

    public void addHeader(String name, String value) {
        List values = this.getHeaderValues(name).orElseGet(() -> {
            ArrayList emptyValues = new ArrayList();
            this.getHeaders().put(name, emptyValues);
            return emptyValues;
        });
        values.add(value);
    }

    public boolean containsHeader(String name) {
        return this.getHeaderValues(name).map(values -> !values.isEmpty()).orElse(false);
    }

    public String getHeader(String name) {
        return this.getHeaderValues(name).map(values -> values.isEmpty() ? null : (String)values.get(0)).orElse(null);
    }

    private Optional<List<String>> getHeaderValues(String name) {
        for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)entry.getKey())) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Collection<String> getHeaders(String name) {
        return this.getHeaderValues(name).map(ArrayList::new).orElseGet(ArrayList::new);
    }

    public Collection<String> getHeaderNames() {
        return new LinkedHashSet<String>(this.getHeaders().keySet());
    }

    private Map<String, List<String>> getHeaders() {
        try {
            return this.response.getHeaders();
        }
        catch (Exception e) {
            LOGGER.debug("Failed to retrieve the WebSocket handshake response headers. This can happen if the HandshakeResponse object is used after the handshake is performed, e.g. in the WebSocket end-point.", (Throwable)e);
            return new HashMap<String, List<String>>();
        }
    }

    public void setHeader(String name, String value) {
        Set namesToRemove = this.getHeaders().keySet().stream().filter(headerName -> StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)headerName)).collect(Collectors.toSet());
        this.getHeaders().keySet().removeAll(namesToRemove);
        this.getHeaders().put(name, new ArrayList<String>(Arrays.asList(value)));
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, this.toDateString(date));
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, this.toDateString(date));
    }

    private String toDateString(long date) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.of("GMT")).format(Instant.ofEpochMilli(date));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public void addCookie(Cookie cookie) {
        StringBuilder header = new StringBuilder();
        header.append(cookie.getName()).append("=\"").append(cookie.getValue()).append('\"');
        if (cookie.getDomain() != null) {
            header.append("; Domain=").append(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            header.append("; Path=").append(cookie.getPath());
        }
        if (cookie.getMaxAge() >= 0) {
            header.append("; Max-Age=").append(cookie.getMaxAge());
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getSecure()) {
            header.append("; Secure");
        }
        this.addHeader("Set-Cookie", header.toString());
    }
}

