/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.websocket.CloseReason;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.websocket.EndpointComponent;
import org.xwiki.websocket.WebSocketContext;

@Component
@Named(value="org.xwiki.websocket.internal.StaticEchoEndpoint")
@ServerEndpoint(value="/echo")
@Singleton
public class StaticEchoEndpoint
implements EndpointComponent {
    @Inject
    protected Logger logger;
    @Inject
    protected WebSocketContext context;
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private ModelContext modelContext;

    @OnOpen
    public void onOpen(Session session) {
        this.context.run(session, () -> {
            if (this.bridge.getCurrentUserReference() == null) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "We don't accept connections from guest users. Please login first."));
                }
                catch (IOException e) {
                    this.logger.warn("Failed to close the session.", (Throwable)e);
                }
            }
        });
    }

    @OnMessage
    public String onMessage(Session session, String message) throws Exception {
        return (String)this.context.call(session, () -> {
            String currentWiki = this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI).getName();
            return String.format("[%s] %s -> %s", currentWiki, this.bridge.getCurrentUserReference(), message);
        });
    }
}

