/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.websocket.CloseReason;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.websocket.AbstractXWikiEndpoint;

@Component
@Named(value="echo")
@Singleton
public class DynamicEchoEndpoint
extends AbstractXWikiEndpoint {
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private ModelContext modelContext;

    public void onOpen(Session session, EndpointConfig config) {
        this.context.run(session, () -> {
            if (this.bridge.getCurrentUserReference() == null) {
                this.close(session, (CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "We don't accept connections from guest users. Please login first.");
            } else {
                session.addMessageHandler(String.class, message -> this.handleMessage(session, message));
            }
        });
    }

    public String onMessage(String message) {
        String currentWiki = this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI).getName();
        return String.format("[%s] %s -> %s", currentWiki, this.bridge.getCurrentUserReference(), message);
    }
}

