/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.util.XWikiStubContextProvider;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiServletResponse;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.Session;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Response;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.container.servlet.ServletSession;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.websocket.WebSocketContext;
import org.xwiki.websocket.internal.XWikiWebSocketRequestStub;
import org.xwiki.websocket.internal.XWikiWebSocketResponseStub;

@Component
@Singleton
public class DefaultWebSocketContext
implements WebSocketContext {
    private static final String WIKI = "wiki";
    private static final String PATH_SEPARATOR = "/";
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private Container container;
    @Inject
    private XWikiStubContextProvider contextProvider;

    public void initialize(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
        ExecutionContext context = this.createExecutionContext(config, request, response);
        config.getUserProperties().put(ExecutionContext.class.getName(), context);
        this.initialize(context);
        this.authenticateUser(request);
    }

    public void run(Session session, Runnable runnable) {
        try {
            this.initialize(this.getExecutionContext(session));
            runnable.run();
        }
        finally {
            this.cleanup(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Session session, Callable<T> callable) throws Exception {
        try {
            this.initialize(this.getExecutionContext(session));
            T t = callable.call();
            return t;
        }
        finally {
            this.cleanup(session);
        }
    }

    private void initialize(ExecutionContext context) {
        if (context == null) {
            throw new RuntimeException("The execution context has not been initialized during the handshake request.");
        }
        this.execution.pushContext(context, false);
        XWikiContext xcontext = this.getXWikiContext();
        if (xcontext != null) {
            if (xcontext.getRequest() != null) {
                this.container.setRequest((Request)new ServletRequest((javax.servlet.http.HttpServletRequest)xcontext.getRequest()));
                this.container.setSession((org.xwiki.container.Session)new ServletSession((javax.servlet.http.HttpServletRequest)xcontext.getRequest()));
            }
            if (xcontext.getResponse() != null) {
                this.container.setResponse((Response)new ServletResponse((HttpServletResponse)xcontext.getResponse()));
            }
        }
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private void cleanup(Session session) {
        ExecutionContext context = this.execution.getContext();
        ExecutionContext storedContext = this.getExecutionContext(session);
        if (context != null && context == storedContext) {
            this.execution.removeContext();
        } else {
            this.logger.warn("The execution context doesn't match the stored session context.");
        }
    }

    private ExecutionContext getExecutionContext(Session session) {
        return (ExecutionContext)session.getUserProperties().get(ExecutionContext.class.getName());
    }

    private ExecutionContext createExecutionContext(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
        ExecutionContext context = new ExecutionContext();
        XWikiContext xcontext = this.contextProvider.createStubContext();
        if (xcontext != null) {
            String wiki = this.getWiki(config, request);
            if (wiki != null) {
                xcontext.setWikiId(wiki);
            }
            xcontext.setRequest((XWikiRequest)new XWikiServletRequest(JakartaServletBridge.toJavax((HttpServletRequest)new XWikiWebSocketRequestStub(request))));
            xcontext.setResponse((XWikiResponse)new XWikiServletResponse(JakartaServletBridge.toJavax((jakarta.servlet.http.HttpServletResponse)new XWikiWebSocketResponseStub(response))));
            xcontext.declareInExecutionContext(context);
        }
        return context;
    }

    private String getWiki(ServerEndpointConfig config, HandshakeRequest request) {
        String wiki = this.getPathParameter(WIKI, request.getRequestURI().getPath(), config.getPath());
        if (wiki == null && request.getParameterMap().containsKey(WIKI)) {
            wiki = (String)((List)request.getParameterMap().get(WIKI)).get(0);
        }
        return wiki;
    }

    private String getPathParameter(String name, String path, String template) {
        List<String> templateElements = Arrays.asList(template.split(PATH_SEPARATOR));
        int pathParamPos = templateElements.indexOf(String.format("{%s}", name));
        if (pathParamPos < 0) {
            return null;
        }
        List<String> pathElements = Arrays.asList(path.split(PATH_SEPARATOR));
        List<String> matchedElements = pathElements.subList(pathElements.size() - templateElements.size(), pathElements.size());
        return matchedElements.get(pathParamPos);
    }

    private void authenticateUser(HandshakeRequest request) {
        XWikiContext xcontext = this.getXWikiContext();
        if (xcontext != null && request.getHttpSession() != null) {
            try {
                XWikiUser xwikiUser = xcontext.getWiki().checkAuth(xcontext);
                if (xwikiUser != null) {
                    xcontext.setUserReference(xwikiUser.getUserReference());
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to authenticate the user for [{}]. Root cause is:", (Object)request.getRequestURI(), (Object)e);
            }
        }
    }
}

