/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket;

import jakarta.websocket.CloseReason;
import jakarta.websocket.EncodeException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Session;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.websocket.EndpointComponent;
import org.xwiki.websocket.WebSocketContext;

public abstract class AbstractXWikiEndpoint
extends Endpoint
implements EndpointComponent {
    private static final String ON_MESSAGE = "onMessage";
    @Inject
    protected Logger logger;
    @Inject
    protected WebSocketContext context;

    protected <T> void handleMessage(Session session, T message) {
        this.handleMessage(session, message, true);
    }

    protected <T> void handleMessage(Session session, T message, boolean last) {
        Method onMessage = this.getOnMessageMethod(message.getClass());
        if (onMessage == null) {
            this.logger.warn("Failed to handle WebSocket message because onMessage method is missing.");
            return;
        }
        this.context.run(session, () -> {
            try {
                Object output = this.invokeOnMessage(onMessage, session, message, last);
                if (onMessage.getReturnType().equals(message.getClass()) && output != null) {
                    session.getBasicRemote().sendObject(output);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.logger.warn("Failed to call onMessage. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            catch (EncodeException | IOException e) {
                this.logger.warn("Failed to send back the WebSocket message. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        });
    }

    private <T> Method getOnMessageMethod(Class<T> messageType) {
        ArrayList<Class[]> onMessageSignatures = new ArrayList<Class[]>();
        onMessageSignatures.add(new Class[]{Session.class, messageType, Boolean.TYPE});
        onMessageSignatures.add(new Class[]{Session.class, messageType});
        onMessageSignatures.add(new Class[]{messageType});
        for (Class[] signature : onMessageSignatures) {
            try {
                return ((Object)((Object)this)).getClass().getMethod(ON_MESSAGE, signature);
            }
            catch (NoSuchMethodException | SecurityException exception) {
            }
        }
        return null;
    }

    private <T> Object invokeOnMessage(Method onMessage, Session session, T message, boolean last) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (onMessage.getParameterCount() == 1) {
            return onMessage.invoke((Object)this, message);
        }
        if (onMessage.getParameterCount() == 3) {
            return onMessage.invoke((Object)this, session, message, last);
        }
        if (onMessage.getParameterTypes()[0] == Session.class) {
            return onMessage.invoke((Object)this, session, message);
        }
        return onMessage.invoke((Object)this, message, last);
    }

    protected void close(Session session, CloseReason.CloseCode closeCode, String reasonPhrase) {
        try {
            session.close(new CloseReason(closeCode, reasonPhrase));
        }
        catch (IOException e) {
            this.logger.warn("Failed to close the session.", (Throwable)e);
        }
    }
}

