/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal.filter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.compiler.LESSCompiler;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.webjars.internal.filter.WebJarsResourceFilter;

@Component
@Named(value="less")
@Singleton
public class LessWebJarsResourceFilter
implements WebJarsResourceFilter {
    @Inject
    private LESSCompiler lessCompiler;

    @Override
    public InputStream filter(InputStream resourceStream, String resourceName) throws ResourceReferenceHandlerException {
        WebjarLESSResourceReference lessResourceReference = new WebjarLESSResourceReference(resourceStream, resourceName);
        try {
            String compile = this.lessCompiler.compile((LESSResourceReference)lessResourceReference, true, false, false);
            return IOUtils.toInputStream((String)compile, (Charset)StandardCharsets.UTF_8);
        }
        catch (LESSCompilerException e) {
            throw new ResourceReferenceHandlerException(String.format("Error when compiling the resource [%s]", resourceName), (Throwable)e);
        }
    }

    private static class WebjarLESSResourceReference
    implements LESSResourceReference {
        private final InputStream resourceStream;
        private final String resourceName;

        WebjarLESSResourceReference(InputStream resourceStream, String resourceName) {
            this.resourceStream = resourceStream;
            this.resourceName = resourceName;
        }

        public String getContent(String skin) throws LESSCompilerException {
            try {
                return IOUtils.toString((InputStream)this.resourceStream, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new LESSCompilerException(String.format("Failed to load the webjar resource [%s]", this.serialize()), (Exception)e);
            }
        }

        public String serialize() {
            return this.resourceName;
        }
    }
}

