/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.url.filesystem.FilesystemExportContext;

public class FilesystemResourceReferenceCopier {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemResourceReferenceCopier.class);
    private static final Pattern URL_PATTERN = Pattern.compile("url\\(['\"](.*?)['\"]\\)");
    private static final String CONCAT_PATH_FORMAT = "%s/%s";

    private File getJARFile(String resourceName) throws IOException {
        URL resourceURL = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (resourceURL != null) {
            File file;
            JarURLConnection connection = (JarURLConnection)resourceURL.openConnection();
            URL jarURL = connection.getJarFileURL();
            try {
                file = new File(jarURL.toURI());
            }
            catch (URISyntaxException e) {
                file = new File(jarURL.getPath());
            }
            return file;
        }
        LOGGER.debug("Cannot construct JAR File for resource [{}] which couldn't be found in the context ClassLoader.", (Object)resourceName);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyResourceFromJAR(String resourcePrefix, String resourceName, String targetPrefix, FilesystemExportContext exportContext) throws IOException {
        String resourcePath = String.format(CONCAT_PATH_FORMAT, resourcePrefix, resourceName);
        File jarFile = this.getJARFile(resourcePath);
        if (jarFile == null) {
            return;
        }
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry entry = enumeration.nextElement();
                if (!entry.getName().startsWith(resourcePath) || entry.isDirectory()) continue;
                String targetPath = targetPrefix + entry.getName().substring(resourcePrefix.length());
                File targetLocation = new File(exportContext.getExportDir(), targetPath);
                if (targetLocation.exists()) continue;
                targetLocation.getParentFile().mkdirs();
                InputStream is = jar.getInputStream(entry);
                try (FileOutputStream fos = new FileOutputStream(targetLocation);){
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                }
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCSS(String resourcePrefix, String resourceName, String targetPrefix, FilesystemExportContext exportContext) throws Exception {
        String resourcePath = String.format(CONCAT_PATH_FORMAT, resourcePrefix, resourceName);
        File jarFile = this.getJARFile(resourcePath);
        if (jarFile == null) {
            return;
        }
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry entry = enumeration.nextElement();
                if (!entry.getName().equals(resourcePath)) continue;
                this.processCSSfile(resourcePrefix, targetPrefix, entry, jar, exportContext);
                break;
            }
        }
    }

    private void processCSSfile(String resourcePrefix, String targetPrefix, JarEntry entry, JarFile jar, FilesystemExportContext exportContext) throws Exception {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(jar.getInputStream(entry), "UTF-8"));){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher matcher = URL_PATTERN.matcher(line);
                while (matcher.find()) {
                    String url = matcher.group(1);
                    if (!this.isRelativeURL(url)) continue;
                    url = StringUtils.substringBefore((String)url, (String)"?");
                    url = StringUtils.substringBefore((String)url, (String)"#");
                    String resourceName = String.format(CONCAT_PATH_FORMAT, StringUtils.substringBeforeLast((String)entry.getName(), (String)"/"), url);
                    resourceName = new URI(resourceName).normalize().getPath();
                    resourceName = resourceName.substring(resourcePrefix.length() + 1);
                    this.copyResourceFromJAR(resourcePrefix, resourceName, targetPrefix, exportContext);
                }
            }
        }
    }

    private boolean isRelativeURL(String url) {
        try {
            return !new URI(url).isAbsolute();
        }
        catch (URISyntaxException e) {
            LOGGER.debug("Failed to find if URL is relative or not for [{}]. Don't copy it to the filesystem. Error: [{}]", (Object)url, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return false;
        }
    }
}

