/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.webjars.WebJarsUrlFactory;
import org.xwiki.webjars.internal.WebJarsResourceReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultWebJarsUrlFactory
implements WebJarsUrlFactory {
    private static final String RESOURCE_SEPARATOR = "/";
    private static final String VERSION = "version";
    private static final String WIKI = "wiki";
    @Inject
    private Logger logger;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private ResourceReferenceSerializer<ResourceReference, ExtendedURL> defaultResourceReferenceSerializer;

    @Override
    public String url(String resourceName) {
        if (StringUtils.isEmpty((CharSequence)resourceName)) {
            return null;
        }
        String[] parts = resourceName.split(RESOURCE_SEPARATOR, 3);
        if (parts.length < 3) {
            this.logger.warn("Invalid webjar resource name [{}]. Expected format is 'webjarId/version/path'", (Object)resourceName);
            return null;
        }
        return this.url("fakeGroupId:" + parts[0], null, parts[2], Collections.singletonMap(VERSION, parts[1]));
    }

    @Override
    public String url(String webjarId, String path) {
        return this.url(webjarId, null, path, null);
    }

    @Override
    public String url(String webjarId, String namespace, String path) {
        return this.url(webjarId, namespace, path, null);
    }

    @Override
    public String url(String webjarId, String path, Map<String, ?> params) {
        String wikiId;
        String namespace = null;
        if (params != null && !StringUtils.isEmpty((CharSequence)(wikiId = (String)params.get(WIKI)))) {
            namespace = this.constructNamespace(wikiId);
        }
        return this.url(webjarId, namespace, path, params);
    }

    @Override
    public String url(String webjarId, String namespace, String path, Map<String, ?> params) {
        ExtendedURL extendedURL;
        Extension extension;
        if (StringUtils.isEmpty((CharSequence)webjarId)) {
            return null;
        }
        String groupId = "org.webjars";
        String artifactId = webjarId;
        int groupSeparatorPosition = webjarId.indexOf(58);
        if (groupSeparatorPosition >= 0) {
            groupId = webjarId.substring(0, groupSeparatorPosition);
            artifactId = webjarId.substring(groupSeparatorPosition + 1);
        }
        String extensionId = String.format("%s:%s", groupId, artifactId);
        LinkedHashMap<String, Object> urlParams = new LinkedHashMap<String, Object>();
        if (params != null) {
            urlParams.putAll(params);
        }
        urlParams.remove(WIKI);
        String version = (String)urlParams.remove(VERSION);
        WebJarsResourceReference resourceReference = version == null ? ((extension = this.getExtension(extensionId, namespace)) != null ? this.getResourceReference(this.getArtifactId(extension.getId().getId()), extension.getId().getVersion().getValue(), namespace, path, urlParams) : this.getResourceReference(artifactId, null, namespace, path, urlParams)) : this.getResourceReference(artifactId, version, namespace, path, urlParams);
        try {
            extendedURL = (ExtendedURL)this.defaultResourceReferenceSerializer.serialize((ResourceReference)resourceReference);
        }
        catch (SerializeResourceReferenceException | UnsupportedResourceReferenceException e) {
            this.logger.warn("Error while serializing WebJar URL for id [{}], path = [{}]. Root cause = [{}]", new Object[]{webjarId, path, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return null;
        }
        return extendedURL.serialize();
    }

    private String getArtifactId(String extensionId) {
        String artifactId = extensionId;
        int groupSeparatorPosition = extensionId.indexOf(58);
        if (groupSeparatorPosition >= 0) {
            artifactId = extensionId.substring(groupSeparatorPosition + 1);
        }
        return artifactId;
    }

    private WebJarsResourceReference getResourceReference(String artifactId, String version, String namespace, String path, Map<String, Object> urlParams) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(artifactId);
        if (version != null) {
            segments.add(version);
        }
        segments.addAll(Arrays.asList(path.split(RESOURCE_SEPARATOR)));
        if (path.endsWith(".js") && urlParams.isEmpty()) {
            urlParams.put("r", "1");
        }
        WebJarsResourceReference resourceReference = new WebJarsResourceReference(this.resolveNamespace(namespace), segments);
        for (Map.Entry<String, Object> parameterEntry : urlParams.entrySet()) {
            resourceReference.addParameter(parameterEntry.getKey(), parameterEntry.getValue());
        }
        return resourceReference;
    }

    private Extension getExtension(String extensionId, String namespace) {
        String selectedNamespace;
        CoreExtension extension = this.coreExtensionRepository.getCoreExtension(extensionId);
        if (extension == null && (extension = this.installedExtensionRepository.getInstalledExtension(extensionId, selectedNamespace = this.resolveNamespace(namespace))) == null) {
            selectedNamespace = this.constructNamespace(this.wikiDescriptorManager.getMainWikiId());
            extension = this.installedExtensionRepository.getInstalledExtension(extensionId, selectedNamespace);
        }
        return extension;
    }

    private String resolveNamespace(String namespace) {
        String resolvedNamespace = StringUtils.isNotEmpty((CharSequence)namespace) ? namespace : this.constructNamespace(this.getCurrentWikiId());
        return resolvedNamespace;
    }

    private String getCurrentWikiId() {
        return this.wikiDescriptorManager.getCurrentWikiId();
    }

    private String constructNamespace(String wikiId) {
        return String.format("wiki:%s", wikiId);
    }
}

