/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.group;

import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.DocumentReference;

@Component(roles={WikiGroupCache.class})
@Singleton
public class WikiGroupCache
implements Initializable,
Disposable {
    private static final int DEFAULT_CAPACITY = 1000;
    protected Cache<Set<DocumentReference>> cache;
    @Inject
    private CacheManager cacheManager;

    public void initialize() throws InitializationException {
        try {
            this.cache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("user.groups", 1000));
        }
        catch (Exception e) {
            throw new InitializationException("Failed to create the group cache", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        this.cache.dispose();
    }

    public Set<DocumentReference> get(String wiki) {
        return (Set)this.cache.get(wiki);
    }

    public void set(String wiki, Set<DocumentReference> groups) {
        this.cache.set(wiki, groups);
    }

    public void invalidate(String wiki) {
        this.cache.remove(wiki);
    }
}

