/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectEvent;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObjectReference;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.RegexEntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.user.internal.document.UserCache;

@Component
@Named(value="org.xwiki.user.internal.document.UserListener")
@Singleton
public class UserListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.user.internal.document.UserListener";
    private static final RegexEntityReference USER_REFERENCE = BaseObjectReference.any((String)XWikiUsersDocumentInitializer.CLASS_REFERENCE_STRING);
    @Inject
    private UserCache cache;

    public UserListener() {
        super(NAME, new Event[]{new XObjectAddedEvent((EntityReference)USER_REFERENCE), new XObjectDeletedEvent((EntityReference)USER_REFERENCE), new WikiDeletedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof XObjectEvent) {
            XWikiDocument document = (XWikiDocument)source;
            WikiReference wiki = document.getDocumentReference().getWikiReference();
            if (event instanceof XObjectAddedEvent) {
                this.cache.set(wiki, true);
            } else if (event instanceof XObjectDeletedEvent) {
                this.cache.invalidate(wiki);
            }
        } else if (event instanceof WikiDeletedEvent) {
            WikiDeletedEvent wikiEvent = (WikiDeletedEvent)event;
            this.cache.invalidate(new WikiReference(wikiEvent.getWikiId()));
        }
    }
}

