/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.commons.lang3.function.FailableFunction;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.WikiReference;

@Component(roles={UserCache.class})
@Singleton
public class UserCache
implements Initializable,
Disposable {
    @Inject
    private CacheManager cacheManager;
    private Cache<Boolean> hasUserCache;

    public void initialize() throws InitializationException {
        try {
            this.hasUserCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("user.hasUsers"));
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to create the cache to store if a user exist in a given wiki", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        this.hasUserCache.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> boolean computeIfAbsent(WikiReference wikiReference, FailableFunction<WikiReference, Boolean, E> function) throws E {
        Boolean hasUser = (Boolean)this.hasUserCache.get(wikiReference.getName());
        if (hasUser == null) {
            Cache<Boolean> cache = this.hasUserCache;
            synchronized (cache) {
                hasUser = (Boolean)function.apply((Object)wikiReference);
                this.hasUserCache.set(wikiReference.getName(), (Object)hasUser);
            }
        }
        return hasUser;
    }

    public void set(WikiReference wikiReference, Boolean hasUsers) {
        if (hasUsers == null) {
            this.invalidate(wikiReference);
        } else {
            this.hasUserCache.set(wikiReference.getName(), (Object)hasUsers);
        }
    }

    public void invalidate(WikiReference wikiReference) {
        this.hasUserCache.remove(wikiReference.getName());
    }
}

