/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Named(value="document")
@Singleton
public class DocumentStringUserReferenceSerializer
implements UserReferenceSerializer<String> {
    private static final String SUPERADMIN_REFERENCE_STRING = "XWiki.superadmin";
    private static final String GUEST_REFERENCE_STRING = "XWiki.XWikiGuest";
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserReferenceUserReferenceResolver;

    public String serialize(UserReference userReference) {
        return this.serialize(userReference, new Object[0]);
    }

    public String serialize(UserReference userReference, Object ... parameters) {
        UserReference resolvedReference;
        String result = userReference == null ? null : (SuperAdminUserReference.INSTANCE == (resolvedReference = CurrentUserReference.INSTANCE == userReference ? this.currentUserReferenceUserReferenceResolver.resolve(null, new Object[0]) : userReference) ? SUPERADMIN_REFERENCE_STRING : (GuestUserReference.INSTANCE == resolvedReference ? GUEST_REFERENCE_STRING : this.serializeInternal(resolvedReference, parameters)));
        return result;
    }

    private String serializeInternal(UserReference userReference, Object ... parameters) {
        if (!(userReference instanceof DocumentUserReference)) {
            throw new IllegalArgumentException("Only DocumentUserReference are handled");
        }
        DocumentUserReference documentUserReference = (DocumentUserReference)userReference;
        String result = (String)this.getEntityReferenceSerializer().serialize((EntityReference)documentUserReference.getReference(), parameters);
        return result;
    }

    protected EntityReferenceSerializer<String> getEntityReferenceSerializer() {
        return this.entityReferenceSerializer;
    }
}

