/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.internal.document.AbstractUserReferenceResolver;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Named(value="document")
@Singleton
public class DocumentDocumentReferenceUserReferenceResolver
extends AbstractUserReferenceResolver<DocumentReference> {
    @Inject
    private EntityReferenceProvider entityReferenceProvider;
    @Inject
    private EntityReferenceFactory entityReferenceFactory;

    public UserReference resolve(DocumentReference rawReference, Object ... parameters) {
        Object reference;
        if (rawReference == null) {
            reference = GuestUserReference.INSTANCE;
        } else {
            DocumentReference documentReference = (DocumentReference)this.entityReferenceFactory.getReference((EntityReference)rawReference);
            reference = this.resolveName(documentReference.getName());
            if (reference == null) {
                boolean isGlobal = this.entityReferenceProvider.getDefaultReference(EntityType.WIKI).equals((Object)documentReference.getWikiReference());
                reference = new DocumentUserReference(documentReference, isGlobal);
            }
        }
        return reference;
    }
}

