/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.HttpServletUtils;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.context.Execution;
import org.xwiki.url.URLConfiguration;
import org.xwiki.url.URLSecurityManager;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultURLSecurityManager
implements URLSecurityManager {
    private static final char DOT = '.';
    private static final char PERCENT = '%';
    private static final String PERCENT_ESCAPE = "__XWIKI_URL_SECURITY_PERCENT__";
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final String ERROR_TRANSFORMING_URI_LOG = "Error while transforming redirect to [{}] to proper URI: [{}]";
    private static final String FULL_STACK_TRACE = "Full stack trace:";
    @Inject
    private URLConfiguration urlConfiguration;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Container container;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;
    private Set<String> trustedDomains;

    private synchronized void computeTrustedDomains() {
        if (this.trustedDomains != null) {
            return;
        }
        ConcurrentHashMap.KeySetView<String, Boolean> result = ConcurrentHashMap.newKeySet();
        result.addAll(this.urlConfiguration.getTrustedDomains());
        try {
            for (WikiDescriptor wikiDescriptor : this.wikiDescriptorManager.getAll()) {
                result.addAll(wikiDescriptor.getAliases());
            }
        }
        catch (WikiManagerException e) {
            this.logger.warn("Error while getting wiki descriptor to fill list of trusted domains: [{}]. The subwikis won't be taken into account for the list of trusted domains.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        this.trustedDomains = result;
    }

    private String getCurrentDomain() {
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest) {
            ServletRequest servletRequest = (ServletRequest)request;
            try {
                URL sourceBaseURL = HttpServletUtils.getSourceBaseURL((HttpServletRequest)servletRequest.getRequest());
                return sourceBaseURL.getHost();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(String.format("Failed to resolve the source URL: [%s]", servletRequest.getRequest().toString()), e);
            }
        }
        return "";
    }

    public boolean isDomainTrusted(URL urlToCheck) {
        if (this.urlConfiguration.isTrustedDomainsEnabled()) {
            boolean bypassCheck;
            this.maybeInitializeWithDomain(this.getCurrentDomain());
            String host = urlToCheck.getHost();
            do {
                if (!this.trustedDomains.contains(host)) continue;
                return true;
            } while (!"".equals(host = StringUtils.contains((CharSequence)host, (int)46) ? host.substring(host.indexOf(46) + 1) : ""));
            Object bypassCheckProperty = this.execution.getContext().getProperty("bypassDomainSecurityCheck");
            boolean bl = bypassCheck = bypassCheckProperty != null && Boolean.parseBoolean(bypassCheckProperty.toString());
            if (bypassCheck) {
                this.logger.info("Domain of URL [{}] does not belong to the list of trusted domains but it's considered as trusted since the check has been bypassed.", (Object)urlToCheck);
            }
            return bypassCheck;
        }
        return true;
    }

    private void maybeInitializeWithDomain(String domain) {
        if (this.urlConfiguration.isTrustedDomainsEnabled()) {
            if (this.trustedDomains == null) {
                this.computeTrustedDomains();
            }
            this.trustedDomains.add(domain);
        }
    }

    public void invalidateCache() {
        this.trustedDomains = null;
    }

    public boolean isURITrusted(URI uri) {
        boolean result = true;
        if (uri.isOpaque() || uri.getAuthority() == null && uri.isAbsolute()) {
            result = false;
        } else if (uri.getAuthority() != null) {
            try {
                if (!uri.isAbsolute()) {
                    URI uriWithScheme = new URI("https", uri.getRawAuthority(), uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment());
                    result = this.isDomainTrusted(uriWithScheme.toURL());
                } else {
                    result = this.urlConfiguration.getTrustedSchemes().contains(uri.getScheme().toLowerCase()) ? this.isDomainTrusted(uri.toURL()) : false;
                }
            }
            catch (MalformedURLException e) {
                this.logger.error("Error while transforming URI [{}] to URL: [{}]", (Object)uri, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                this.logger.debug("Full error stack trace of the URL resolution: ", (Throwable)e);
                result = false;
            }
            catch (URISyntaxException e) {
                this.logger.error("Error while transforming URI [{}] to absolute URI with http scheme: [{}]", (Object)uri, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                this.logger.debug("Full error stack trace of the URI resolution: ", (Throwable)e);
            }
        }
        return result;
    }

    public URI parseToSafeURI(String serializedURI) throws URISyntaxException, SecurityException {
        URI uri;
        try {
            uri = new URI(serializedURI);
        }
        catch (URISyntaxException e) {
            if (serializedURI.contains(PERCENT_ESCAPE)) {
                throw new IllegalArgumentException(String.format("The given uri [%s] contains the string [%s] which is used internally for performing escaping operations when trying to 'repair' a URI which cannot be parsed. Check the original error for repairing the URI or try to use a different marker.", serializedURI, PERCENT_ESCAPE), e);
            }
            Matcher matcher = URI_PATTERN.matcher(serializedURI);
            if (matcher.matches()) {
                String scheme = matcher.group(2);
                String authority = this.replaceUnquotedPercent(matcher.group(4));
                String path = this.replaceUnquotedPercent(matcher.group(5));
                String query = this.replaceUnquotedPercent(matcher.group(7));
                String fragment = this.replaceUnquotedPercent(matcher.group(9));
                uri = new URI(scheme, authority, path, query, fragment);
                uri = new URI(uri.toString().replace(PERCENT_ESCAPE, "%"));
            }
            throw e;
        }
        if (this.isURITrusted(uri)) {
            return uri;
        }
        throw new SecurityException(String.format("The given URI [%s] is not safe on this server.", uri));
    }

    public URI parseToSafeURI(String serializedURI, String requestHost) throws URISyntaxException, SecurityException {
        this.maybeInitializeWithDomain(requestHost);
        return this.parseToSafeURI(serializedURI);
    }

    private String replaceUnquotedPercent(String originalString) {
        if (!StringUtils.isBlank((CharSequence)originalString) && originalString.indexOf(37) > -1) {
            StringBuilder result = new StringBuilder();
            char[] charArray = originalString.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char currentChar = charArray[i];
                if (currentChar == '%' && i < charArray.length - 2 && this.isQuotedChar(charArray[i + 1]) && this.isQuotedChar(charArray[i + 2])) {
                    result.append(PERCENT_ESCAPE);
                    continue;
                }
                result.append(currentChar);
            }
            return result.toString();
        }
        return originalString;
    }

    private boolean isQuotedChar(char nextChar) {
        boolean result = nextChar >= '0' && nextChar <= '9' ? true : (nextChar >= 'A' && nextChar <= 'F' ? true : nextChar >= 'a' && nextChar <= 'f');
        return result;
    }
}

