/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.url.FrontendURLCheckPolicy;
import org.xwiki.url.URLConfiguration;

@Component
@Singleton
public class DefaultURLConfiguration
implements URLConfiguration {
    private static final String PREFIX = "url.";
    @Inject
    private Provider<ConfigurationSource> configuration;

    public String getURLFormatId() {
        return (String)((ConfigurationSource)this.configuration.get()).getProperty("url.format", (Object)"standard");
    }

    public boolean useResourceLastModificationDate() {
        return (Boolean)((ConfigurationSource)this.configuration.get()).getProperty("url.useResourceLastModificationDate", (Object)true);
    }

    public List<String> getTrustedDomains() {
        return (List)((ConfigurationSource)this.configuration.get()).getProperty("url.trustedDomains", List.of());
    }

    public boolean isTrustedDomainsEnabled() {
        return (Boolean)((ConfigurationSource)this.configuration.get()).getProperty("url.trustedDomainsEnabled", (Object)true);
    }

    public List<String> getTrustedSchemes() {
        return (List)((ConfigurationSource)this.configuration.get()).getProperty("url.trustedSchemes", List.of("http", "https", "ftp"));
    }

    public FrontendURLCheckPolicy getFrontendUrlCheckPolicy() {
        String deprecatedProperty = "url.frontendUrlCheckEnabled";
        String newProperty = "url.frontendUrlCheckPolicy";
        ConfigurationSource configurationSource = (ConfigurationSource)this.configuration.get();
        FrontendURLCheckPolicy result = FrontendURLCheckPolicy.COMMENTS;
        if (configurationSource.containsKey(newProperty)) {
            String propertyString = (String)configurationSource.getProperty(newProperty);
            try {
                result = FrontendURLCheckPolicy.valueOf((String)propertyString.toUpperCase());
            }
            catch (Throwable e) {
                result = FrontendURLCheckPolicy.COMMENTS;
            }
        } else if (configurationSource.containsKey(deprecatedProperty)) {
            result = (Boolean)configurationSource.getProperty(deprecatedProperty, Boolean.class) != false ? FrontendURLCheckPolicy.ENABLED : FrontendURLCheckPolicy.DISABLED;
        }
        return result;
    }

    public List<String> getAllowedFrontendUrls() {
        return (List)((ConfigurationSource)this.configuration.get()).getProperty("url.allowedFrontendUrls", List.of());
    }
}

