/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.xwiki.component.annotation.Role;
import org.xwiki.stability.Unstable;

@Role
public interface URLSecurityManager {
    public static final String BYPASS_DOMAIN_SECURITY_CHECK_CONTEXT_PROPERTY = "bypassDomainSecurityCheck";

    public boolean isDomainTrusted(URL var1);

    default public boolean isURITrusted(URI uri) {
        return false;
    }

    default public URI parseToSafeURI(String serializedURI) throws URISyntaxException, SecurityException {
        throw new SecurityException("Cannot guarantee safeness of " + serializedURI);
    }

    @Unstable
    default public URI parseToSafeURI(String serializedURI, String requestHost) throws URISyntaxException, SecurityException {
        throw new SecurityException("Cannot guarantee that " + serializedURI + " is safe.");
    }
}

