/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.velocity.tools.EscapeTool;

public class ExtendedURL
implements Cloneable {
    private static final String URL_SEPARATOR = "/";
    private static final String UTF8 = "UTF-8";
    private URI uri;
    private URL wrappedURL;
    private List<String> segments;
    private Map<String, List<String>> parameters;
    private EscapeTool escapeTool = new EscapeTool();

    public ExtendedURL(List<String> segments) {
        this(segments, Collections.emptyMap());
    }

    public ExtendedURL(List<String> segments, Map<String, List<String>> parameters) {
        this.segments = new ArrayList<String>(segments);
        this.parameters = parameters;
    }

    public ExtendedURL(URL url, String ignorePrefix) throws CreateResourceReferenceException {
        URI internalURI;
        this.wrappedURL = url;
        try {
            internalURI = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new CreateResourceReferenceException(String.format("Invalid URL [%s]", url), (Throwable)e);
        }
        this.uri = internalURI;
        String rawPath = this.getURI().getRawPath();
        if (!StringUtils.isEmpty((CharSequence)ignorePrefix)) {
            Object normalizedIgnorePrefix = ignorePrefix;
            if (!ignorePrefix.startsWith(URL_SEPARATOR)) {
                normalizedIgnorePrefix = URL_SEPARATOR + ignorePrefix;
            }
            if (!this.getURI().getPath().startsWith((String)normalizedIgnorePrefix)) {
                throw new CreateResourceReferenceException(String.format("URL Path [%s] doesn't start with [%s]", this.getURI().getPath(), ignorePrefix));
            }
            rawPath = rawPath.substring(((String)normalizedIgnorePrefix).length());
        }
        rawPath = Strings.CS.removeStart(rawPath, (CharSequence)URL_SEPARATOR);
        this.segments = this.extractPathSegments(rawPath);
        this.parameters = this.extractParameters(internalURI);
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public URL getWrappedURL() {
        return this.wrappedURL;
    }

    public URI getURI() {
        return this.uri;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    protected Map<String, List<String>> extractParameters(URI uri) {
        Map<String, List<String>> uriParameters = uri.getRawQuery() != null ? URLEncodedUtils.parse((String)uri.getRawQuery(), (Charset)StandardCharsets.UTF_8).stream().filter(pair -> StringUtils.isNotBlank((CharSequence)pair.getName())).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.filtering(Objects::nonNull, Collectors.toList())))) : Map.of();
        return uriParameters;
    }

    private List<String> extractPathSegments(String rawPath) {
        ArrayList<String> urlSegments = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)rawPath)) {
            return urlSegments;
        }
        for (String pathSegment : rawPath.split(URL_SEPARATOR, -1)) {
            String decodedPathSegment;
            String normalizedPathSegment = pathSegment.split(";", 2)[0];
            try {
                decodedPathSegment = URLDecoder.decode(normalizedPathSegment, UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(String.format("Failed to URL decode [%s] using UTF-8.", normalizedPathSegment), e);
            }
            urlSegments.add(decodedPathSegment);
        }
        return urlSegments;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 7).append((Object)this.getURI()).append(this.getSegments()).append(this.getParameters()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ExtendedURL rhs = (ExtendedURL)object;
        return new EqualsBuilder().append((Object)this.getURI(), (Object)rhs.getURI()).append(this.getSegments(), rhs.getSegments()).append(this.getParameters(), rhs.getParameters()).isEquals();
    }

    public String serialize() {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> encodedSegments = new ArrayList<String>();
        for (String path : this.getSegments()) {
            encodedSegments.add(this.encodeSegment(path));
        }
        builder.append(URL_SEPARATOR);
        builder.append(StringUtils.join(encodedSegments, (String)URL_SEPARATOR));
        Map<String, List<String>> uriParameters = this.getParameters();
        if (!uriParameters.isEmpty()) {
            builder.append('?');
            builder.append(this.escapeTool.url(uriParameters));
        }
        return builder.toString();
    }

    private String encodeSegment(String value) {
        try {
            return URLEncoder.encode(value, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("Failed to URL encode [%s] using UTF-8.", value), e);
        }
    }

    public String toString() {
        return this.serialize();
    }
}

