/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.script.ScriptContext;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererDecorator;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererResult;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.internal.AbstractWikiUIExtension;
import org.xwiki.uiextension.internal.WikiUIExtensionParameters;

@Component(roles={WikiUIExtension.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikiUIExtension
extends AbstractWikiUIExtension
implements BlockAsyncRendererDecorator {
    public static final String CONTEXT_UIX_KEY = "uix";
    public static final String CONTEXT_UIX_DOC_KEY = "doc";
    public static final String CONTEXT_UIX_INLINE_KEY = "inline";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ScriptContextManager scriptContextManager;
    private String id;
    private String extensionPointId;
    private WikiUIExtensionParameters parameters;

    public void initialize(BaseObject baseObject, String roleHint, String id, String extensionPointId) throws WikiComponentException {
        super.initialize(baseObject, UIExtension.class, roleHint);
        this.id = id;
        this.extensionPointId = extensionPointId;
    }

    public void setParameters(WikiUIExtensionParameters parameters) {
        this.parameters = parameters;
    }

    public void setScope(WikiComponentScope scope) {
        this.scope = scope;
    }

    public String getId() {
        return this.id;
    }

    public String getExtensionPointId() {
        return this.extensionPointId;
    }

    public Map<String, String> getParameters() {
        if (this.parameters != null) {
            return this.parameters.get();
        }
        return Collections.emptyMap();
    }

    private PreviousContexts before(boolean inline) throws RenderingException {
        XWikiDocument document;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            document = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
        }
        catch (XWikiException e) {
            throw new RenderingException("Failed to get ui extension document", (Throwable)e);
        }
        HashMap<String, Object> uixContext = new HashMap<String, Object>();
        uixContext.put(CONTEXT_UIX_DOC_KEY, document.newDocument(xcontext));
        uixContext.put(CONTEXT_UIX_INLINE_KEY, inline);
        Map previousUIXContext = (Map)xcontext.get((Object)CONTEXT_UIX_KEY);
        xcontext.put((Object)CONTEXT_UIX_KEY, uixContext);
        ScriptContext scriptContext = this.scriptContextManager.getCurrentScriptContext();
        Object previousScriptUIXContext = scriptContext.getAttribute(CONTEXT_UIX_KEY, 100);
        scriptContext.setAttribute(CONTEXT_UIX_KEY, uixContext, 100);
        return new PreviousContexts(previousUIXContext, previousScriptUIXContext);
    }

    private void after(PreviousContexts contexts) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        xcontext.put((Object)CONTEXT_UIX_KEY, contexts.previousUIXContext);
        this.scriptContextManager.getCurrentScriptContext().setAttribute(CONTEXT_UIX_KEY, contexts.previousScriptUIXContext, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockAsyncRendererResult render(BlockAsyncRenderer renderer, boolean async, boolean cached) throws RenderingException {
        PreviousContexts contexts = this.before(renderer.isInline());
        try {
            BlockAsyncRendererResult blockAsyncRendererResult = renderer.render(async, cached);
            return blockAsyncRendererResult;
        }
        finally {
            this.after(contexts);
        }
    }

    private final class PreviousContexts {
        private final Object previousUIXContext;
        private final Object previousScriptUIXContext;

        private PreviousContexts(Object previousUIXContext, Object previousScriptUIXContext) {
            this.previousUIXContext = previousUIXContext;
            this.previousScriptUIXContext = previousScriptUIXContext;
        }
    }
}

