/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal.macro;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.UIExtensionManager;
import org.xwiki.uiextension.macro.UIExtensionsMacroParameters;

@Component
@Named(value="uiextensions")
@Singleton
public class UIExtensionsMacro
extends AbstractMacro<UIExtensionsMacroParameters> {
    private static final String DESCRIPTION = "Insert UI extensions.";
    @Inject
    private UIExtensionManager uiExtensionManager;

    public UIExtensionsMacro() {
        super("UI Extensions", DESCRIPTION, UIExtensionsMacroParameters.class);
        this.setDefaultCategories(Set.of("Development"));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(UIExtensionsMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<UIExtension> extensions = this.uiExtensionManager.get(parameters.getExtensionPoint());
        ArrayList<Block> results = new ArrayList<Block>();
        for (UIExtension extension : extensions) {
            Block block = extension.execute(context.isInline());
            if (block instanceof XDOM || block instanceof CompositeBlock) {
                results.addAll(block.getChildren());
                continue;
            }
            results.add(block);
        }
        return results;
    }
}

