/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.UIExtensionManager;

@Component
@Singleton
public class DefaultUIExtensionManager
implements UIExtensionManager {
    private static final String FAILED_INSTANCES = "Failed to lookup UIExtension instances";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private AsyncContext asyncContext;

    @Override
    public List<UIExtension> get(String extensionPointId) {
        ArrayList<UIExtension> extensions = new ArrayList<UIExtension>();
        ComponentManager componentManager = (ComponentManager)this.contextComponentManagerProvider.get();
        if (StringUtils.isNotEmpty((CharSequence)extensionPointId) && !extensionPointId.equals("default") && componentManager.hasComponent(UIExtensionManager.class, extensionPointId)) {
            try {
                UIExtensionManager manager = (UIExtensionManager)componentManager.getInstance(UIExtensionManager.class, extensionPointId);
                return manager.get(extensionPointId);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to initialize lookup a specific UIExtensionManager for the hint [{}]", (Object)extensionPointId, (Object)e);
                return extensions;
            }
        }
        try {
            List allExtensions = componentManager.getInstanceList(UIExtension.class);
            for (UIExtension extension : allExtensions) {
                if (!Strings.CS.equals(extension.getExtensionPointId(), extensionPointId)) continue;
                extensions.add(extension);
            }
            this.asyncContext.useComponent(UIExtension.class);
        }
        catch (ComponentLookupException e) {
            this.logger.error(FAILED_INSTANCES, (Throwable)e);
        }
        return extensions;
    }

    @Override
    public Optional<UIExtension> getUIExtension(String id) {
        ComponentManager componentManager = (ComponentManager)this.contextComponentManagerProvider.get();
        try {
            List allExtensions = componentManager.getInstanceList(UIExtension.class);
            for (UIExtension extension : allExtensions) {
                if (!id.equals(extension.getId())) continue;
                return Optional.of(extension);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error(FAILED_INSTANCES, (Throwable)e);
        }
        return Optional.empty();
    }
}

