/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tree.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.tree.AbstractTreeNode;
import org.xwiki.tree.CompositeTreeNodeGroup;
import org.xwiki.tree.TreeNode;
import org.xwiki.tree.TreeNodeGroup;

@Component(roles={CompositeTreeNodeGroup.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultCompositeTreeNodeGroup
extends AbstractTreeNode
implements CompositeTreeNodeGroup {
    private List<Entry> entries = new ArrayList<Entry>();
    private BinaryOperator<String> idGenerator;

    @Override
    public void addTreeNode(TreeNode treeNode, Predicate<String> condition) {
        this.entries.add(new Entry(this.withSameProperties(treeNode), condition));
    }

    @Override
    public void setIdGenerator(BinaryOperator<String> idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public int getChildCount(String nodeId) {
        return this.entries.stream().mapToInt(entry -> this.getLength((Entry)entry, nodeId)).sum();
    }

    private int getLength(Entry entry, String nodeId) {
        if (!entry.condition.test(nodeId)) {
            return 0;
        }
        if (entry.treeNode instanceof TreeNodeGroup) {
            return this.withSameProperties(entry.treeNode).getChildCount(nodeId);
        }
        return 1;
    }

    @Override
    public List<String> getChildren(String nodeId, int offset, int limit) {
        int length;
        int index;
        int count = 0;
        for (index = 0; index < this.entries.size() && count + (length = this.getLength(this.entries.get(index), nodeId)) <= offset; ++index) {
            count += length;
        }
        ArrayList<String> children = new ArrayList<String>();
        while (index < this.entries.size() && (limit < 0 || children.size() < limit)) {
            Entry entry = this.entries.get(index++);
            if (!entry.condition.test(nodeId)) continue;
            if (entry.treeNode instanceof TreeNodeGroup) {
                children.addAll(this.withSameProperties(entry.treeNode).getChildren(nodeId, offset - count, Math.max(limit - children.size(), -1)));
                count = offset;
                continue;
            }
            children.add((String)this.idGenerator.apply(nodeId, entry.treeNode.getType()));
        }
        return children;
    }

    private static class Entry {
        private final TreeNode treeNode;
        private final Predicate<String> condition;

        Entry(TreeNode treeNode, Predicate<String> condition) {
            this.treeNode = treeNode;
            this.condition = condition;
        }
    }
}

